/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

class SecuritySupport {
    private static final SecuritySupport securitySupport = new SecuritySupport();

    SecuritySupport() {
    }

    static SecuritySupport getInstance() {
        return securitySupport;
    }

    ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return cl;
    }

    ClassLoader getSystemClassLoader() {
        ClassLoader cl = null;
        try {
            cl = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return cl;
    }

    ClassLoader getParentClassLoader(ClassLoader cl) {
        ClassLoader parent = null;
        try {
            parent = cl.getParent();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return parent == cl ? null : parent;
    }

    String getSystemProperty(String propName) {
        return System.getProperty(propName);
    }

    FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    InputStream getResourceAsStream(ClassLoader cl, String name) {
        InputStream ris = cl == null ? ClassLoader.getSystemResourceAsStream(name) : cl.getResourceAsStream(name);
        return ris;
    }

    boolean getFileExists(File f) {
        return f.exists();
    }

    long getLastModified(File f) {
        return f.lastModified();
    }
}

