/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.burningwave.core.classes.AnnotationSourceGenerator;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.FunctionSourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.VariableSourceGenerator;

public class ClassSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -4865516517027747031L;
    private Collection<AnnotationSourceGenerator> annotations;
    private Collection<String> outerCode;
    private Integer modifier;
    private String classType;
    private TypeDeclarationSourceGenerator typeDeclaration;
    private String expands;
    private TypeDeclarationSourceGenerator expandedType;
    private String concretize;
    private Collection<TypeDeclarationSourceGenerator> concretizedTypes;
    private Collection<VariableSourceGenerator> enumConstants;
    private Collection<VariableSourceGenerator> fields;
    private Collection<FunctionSourceGenerator> constructors;
    private Collection<FunctionSourceGenerator> methods;
    private Collection<ClassSourceGenerator> innerClasses;
    private BodySourceGenerator staticInitializer;
    private BodySourceGenerator initializer;

    private ClassSourceGenerator(String classType, TypeDeclarationSourceGenerator typeDeclaration) {
        this.classType = classType;
        this.typeDeclaration = typeDeclaration;
    }

    TypeDeclarationSourceGenerator getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public static ClassSourceGenerator create(TypeDeclarationSourceGenerator type) {
        return new ClassSourceGenerator("class", type);
    }

    public static ClassSourceGenerator createInterface(TypeDeclarationSourceGenerator type) {
        return new ClassSourceGenerator("interface", type);
    }

    public static ClassSourceGenerator createAnnotation(TypeDeclarationSourceGenerator type) {
        return new ClassSourceGenerator("@interface", type);
    }

    public static ClassSourceGenerator createEnum(TypeDeclarationSourceGenerator type) {
        return new ClassSourceGenerator("enum", type);
    }

    public ClassSourceGenerator addModifier(Integer modifier) {
        this.modifier = this.modifier == null ? modifier : Integer.valueOf(this.modifier | modifier);
        return this;
    }

    Integer getModifier() {
        return this.modifier;
    }

    String getSimpleName() {
        return this.typeDeclaration.getSimpleName();
    }

    public ClassSourceGenerator expands(Class<?> extendedClass) {
        return this.expands(TypeDeclarationSourceGenerator.create(extendedClass));
    }

    public ClassSourceGenerator expands(TypeDeclarationSourceGenerator expandedType) {
        if (this.classType.equals("interface")) {
            this.concretize = "extends";
            return this.addConcretizedType(expandedType);
        }
        this.expands = "extends";
        this.expandedType = expandedType;
        return this;
    }

    public ClassSourceGenerator addConcretizedType(Class<?> ... concretizedTypes) {
        this.concretize = this.classType.equals("interface") ? "extends" : "implements";
        Optional.ofNullable(this.concretizedTypes).orElseGet(() -> {
            this.concretizedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.concretizedTypes;
        });
        for (Class<?> cls : concretizedTypes) {
            if (this.isAlreadyAdded(cls.getName())) continue;
            this.concretizedTypes.add(TypeDeclarationSourceGenerator.create(cls));
        }
        return this;
    }

    public ClassSourceGenerator addConcretizedType(TypeDeclarationSourceGenerator ... concretizedTypes) {
        this.concretize = this.classType.equals("interface") ? "extends" : "implements";
        Optional.ofNullable(this.concretizedTypes).orElseGet(() -> {
            this.concretizedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.concretizedTypes;
        });
        for (TypeDeclarationSourceGenerator typeDeclarationSG : concretizedTypes) {
            if (this.isAlreadyAdded(typeDeclarationSG.getName())) continue;
            this.concretizedTypes.add(typeDeclarationSG);
        }
        return this;
    }

    private boolean isAlreadyAdded(String className) {
        boolean isAlreadyAdded = false;
        for (TypeDeclarationSourceGenerator typeDeclarationSG : this.concretizedTypes) {
            if (typeDeclarationSG.getName() == null || !typeDeclarationSG.getName().equals(className)) continue;
            isAlreadyAdded = true;
            break;
        }
        return isAlreadyAdded;
    }

    public ClassSourceGenerator setStaticInitializer(BodySourceGenerator initializer) {
        this.staticInitializer = initializer.setDelimiters("static {\n", "\n}").setElementPrefix("\t");
        return this;
    }

    public ClassSourceGenerator setInitializer(BodySourceGenerator initializer) {
        this.initializer = initializer.setDelimiters("{\n", "\n}").setElementPrefix("\t");
        return this;
    }

    public ClassSourceGenerator addOuterCodeLine(String ... codes) {
        Optional.ofNullable(this.outerCode).orElseGet(() -> {
            this.outerCode = new ArrayList<String>();
            return this.outerCode;
        });
        for (String code : codes) {
            if (!this.outerCode.isEmpty()) {
                this.outerCode.add("\n" + code);
                continue;
            }
            this.outerCode.add(code);
        }
        return this;
    }

    public ClassSourceGenerator addAnnotation(AnnotationSourceGenerator ... annotations) {
        Optional.ofNullable(this.annotations).orElseGet(() -> {
            this.annotations = new ArrayList<AnnotationSourceGenerator>();
            return this.annotations;
        });
        for (AnnotationSourceGenerator annotation : annotations) {
            this.annotations.add(annotation);
        }
        return this;
    }

    public ClassSourceGenerator addField(VariableSourceGenerator ... fields) {
        Optional.ofNullable(this.fields).orElseGet(() -> {
            this.fields = new ArrayList<VariableSourceGenerator>();
            return this.fields;
        });
        for (VariableSourceGenerator field : fields) {
            field.setElementPrefix("\t");
            this.fields.add(field);
        }
        return this;
    }

    public ClassSourceGenerator addEnumConstant(VariableSourceGenerator ... enumConstants) {
        Optional.ofNullable(this.enumConstants).orElseGet(() -> {
            this.enumConstants = new ArrayList<VariableSourceGenerator>();
            return this.enumConstants;
        });
        for (VariableSourceGenerator enumConstant : enumConstants) {
            enumConstant.setAssignementOperator("");
            enumConstant.setDelimiter(",");
            this.enumConstants.add(enumConstant);
        }
        ((VariableSourceGenerator)((ArrayList)this.enumConstants).get(this.enumConstants.size() - 1)).setDelimiter(";");
        if (this.enumConstants.size() > 1) {
            ((VariableSourceGenerator)((ArrayList)this.enumConstants).get(this.enumConstants.size() - 2)).setDelimiter(",");
        }
        return this;
    }

    public ClassSourceGenerator addConstructor(FunctionSourceGenerator ... constructors) {
        Optional.ofNullable(this.constructors).orElseGet(() -> {
            this.constructors = new ArrayList<FunctionSourceGenerator>();
            return this.constructors;
        });
        for (FunctionSourceGenerator constructor : constructors) {
            this.constructors.add(constructor);
            constructor.setName(this.typeDeclaration.getSimpleName());
            constructor.setReturnType((TypeDeclarationSourceGenerator)null);
        }
        return this;
    }

    public ClassSourceGenerator addMethod(FunctionSourceGenerator ... methods) {
        Optional.ofNullable(this.methods).orElseGet(() -> {
            this.methods = new ArrayList<FunctionSourceGenerator>();
            return this.methods;
        });
        for (FunctionSourceGenerator method : methods) {
            this.methods.add(method);
        }
        return this;
    }

    public ClassSourceGenerator addInnerClass(ClassSourceGenerator ... classes) {
        Optional.ofNullable(this.innerClasses).orElseGet(() -> {
            this.innerClasses = new ArrayList<ClassSourceGenerator>();
            return this.innerClasses;
        });
        for (ClassSourceGenerator cls : classes) {
            this.innerClasses.add(cls);
        }
        return this;
    }

    private String getAnnotations() {
        return Optional.ofNullable(this.annotations).map(annts -> this.getOrEmpty((Collection<?>)annts, "\n") + "\n").orElseGet(() -> null);
    }

    private String getFieldsCode() {
        return Optional.ofNullable(this.fields).map(flds -> this.getOrEmpty((Collection<?>)flds, "\n")).orElseGet(() -> null);
    }

    private String getEnumConstantsCode() {
        return Optional.ofNullable(this.enumConstants).map(enumCnts -> "\t" + this.getOrEmpty((Collection<?>)enumCnts, "\n").replace("\n", "\n\t")).orElseGet(() -> null);
    }

    private String getStaticInitializer() {
        return Optional.ofNullable(this.staticInitializer).map(stIn -> "\t" + this.getOrEmpty((SourceGenerator)stIn).replace("\n", "\n\t")).orElseGet(() -> null);
    }

    private String getInitializer() {
        return Optional.ofNullable(this.initializer).map(in -> "\t" + this.getOrEmpty((SourceGenerator)in).replace("\n", "\n\t")).orElseGet(() -> null);
    }

    private String getFunctionCode(Collection<FunctionSourceGenerator> functions) {
        return Optional.ofNullable(functions).map(mths -> "\t" + this.getOrEmpty((Collection<?>)mths, "\n\n").replace("\n", "\n\t")).orElseGet(() -> null);
    }

    String getInnerClassesCode() {
        String innerClassesAsString = null;
        if (this.innerClasses != null) {
            Iterator<ClassSourceGenerator> innerClassesItr = this.innerClasses.iterator();
            innerClassesAsString = "\t";
            while (innerClassesItr.hasNext()) {
                innerClassesAsString = innerClassesAsString + innerClassesItr.next().make().replaceAll("\n(.)", "\n\t$1");
                if (!innerClassesItr.hasNext()) continue;
                innerClassesAsString = innerClassesAsString + "\n\n\t";
            }
        }
        return innerClassesAsString;
    }

    Map<String, ClassSourceGenerator> getAllInnerClasses() {
        HashMap<String, ClassSourceGenerator> classes = new HashMap<String, ClassSourceGenerator>();
        Optional.ofNullable(this.innerClasses).ifPresent(innerclasses -> innerclasses.forEach(innerClass -> {
            classes.put(this.typeDeclaration.getSimpleName() + "$" + innerClass.typeDeclaration.getSimpleName(), (ClassSourceGenerator)innerClass);
            for (Map.Entry<String, ClassSourceGenerator> cls : innerClass.getAllInnerClasses().entrySet()) {
                classes.put(this.typeDeclaration.getSimpleName() + "$" + cls.getKey(), cls.getValue());
            }
        }));
        return classes;
    }

    @Override
    public String make() {
        String annotations = this.getAnnotations();
        String staticInitializerCode = this.getStaticInitializer();
        String initializerCode = this.getInitializer();
        String fieldsCode = this.getFieldsCode();
        String enumConstantsCode = this.getEnumConstantsCode();
        String constructorsCode = this.getFunctionCode(this.constructors);
        String methodsCode = this.getFunctionCode(this.methods);
        String innerClassesCode = this.getInnerClassesCode();
        return this.getOrEmpty(this.getOuterCode(), annotations, Optional.ofNullable(this.modifier).map(mod -> Modifier.toString(this.modifier)).orElseGet(() -> null), !this.typeDeclaration.isParameterizable() ? this.classType : "", this.typeDeclaration, this.expands, this.expandedType, this.concretize, this.getOrEmpty(this.concretizedTypes, ", "), "{", enumConstantsCode != null ? "\n\n" + enumConstantsCode : null, fieldsCode != null ? "\n\n" + fieldsCode : null, staticInitializerCode != null ? "\n\n" + staticInitializerCode : null, initializerCode != null ? "\n\n" + initializerCode : null, constructorsCode != null ? "\n\n" + constructorsCode : null, methodsCode != null ? "\n\n" + methodsCode : null, innerClassesCode != null ? "\n\n" + innerClassesCode : null, "\n\n}");
    }

    String getOuterCode() {
        return Optional.ofNullable(this.outerCode).map(outerCode -> this.getOrEmpty((Collection<?>)outerCode) + "\n").orElseGet(() -> null);
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        Collection<TypeDeclarationSourceGenerator> types = this.typeDeclaration.getTypeDeclarations();
        Optional.ofNullable(this.staticInitializer).ifPresent(stcInit -> types.addAll(stcInit.getTypeDeclarations()));
        Optional.ofNullable(this.annotations).ifPresent(annotations -> {
            for (AnnotationSourceGenerator annotation : annotations) {
                types.addAll(annotation.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.expandedType).ifPresent(expandedType -> types.addAll(expandedType.getTypeDeclarations()));
        Optional.ofNullable(this.concretizedTypes).ifPresent(concretizedTypes -> {
            types.addAll((Collection<TypeDeclarationSourceGenerator>)concretizedTypes);
            for (TypeDeclarationSourceGenerator type : concretizedTypes) {
                types.addAll(type.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.fields).ifPresent(fields -> {
            for (VariableSourceGenerator field : fields) {
                types.addAll(field.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.enumConstants).ifPresent(enumConstants -> {
            for (VariableSourceGenerator enumConstant : enumConstants) {
                types.addAll(enumConstant.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.constructors).ifPresent(constructors -> {
            for (FunctionSourceGenerator constructor : constructors) {
                types.addAll(constructor.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.methods).ifPresent(methods -> {
            for (FunctionSourceGenerator method : methods) {
                types.addAll(method.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.innerClasses).ifPresent(innerClasses -> {
            for (ClassSourceGenerator cls : innerClasses) {
                types.addAll(cls.getTypeDeclarations());
            }
        });
        return types;
    }
}

