/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler.output;

import java.util.Set;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public class ErrorTreeAppendable
extends TreeAppendable {
    private LazyURIEncoder encoder = this.getOrCreateURIEncoder();

    public ErrorTreeAppendable(SharedAppendableState state, ITraceURIConverter converter, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, Set<ILocationData> sourceLocations, boolean useForDebugging) {
        super(state, converter, locationProvider, jvmModelAssociations, sourceLocations, useForDebugging);
    }

    protected LazyURIEncoder getOrCreateURIEncoder() {
        Resource resource = this.getState().getResource();
        if (resource instanceof LazyLinkingResource) {
            return ((LazyLinkingResource)resource).getEncoder();
        }
        return new LazyURIEncoder();
    }

    @Override
    public TreeAppendable append(JvmType type) {
        if (type.eIsProxy()) {
            INode linkNode;
            String fragment = ((InternalEObject)type).eProxyURI().fragment();
            Triple unresolvedLink = this.encoder.decode(this.getState().getResource(), fragment);
            if (unresolvedLink != null && (linkNode = (INode)unresolvedLink.getThird()) != null) {
                this.append(NodeModelUtils.getTokenText((INode)linkNode));
                return this;
            }
            this.append("unresolved type");
            return this;
        }
        return super.append(type);
    }

    @Override
    protected TreeAppendable createChild(SharedAppendableState state, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, Set<ILocationData> newData, boolean useForDebugging) {
        return this;
    }
}

