/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.tools.Tool;

public class ResizeTracker
extends Tool {
    private final List<EditPart> m_operationSet;
    private final int m_direction;
    private final Object m_requestType;
    private ChangeBoundsRequest m_request;
    private boolean m_isShowingFeedback;

    public ResizeTracker(int direction, Object requestType) {
        this(null, direction, requestType);
    }

    public ResizeTracker(EditPart selectionEditPart, int direction, Object requestType) {
        if (selectionEditPart == null) {
            this.m_operationSet = null;
        } else {
            this.m_operationSet = new ArrayList<EditPart>();
            this.m_operationSet.add(selectionEditPart);
        }
        this.m_direction = direction;
        this.m_requestType = requestType;
        this.setDefaultCursor(Cursors.getDirectionalCursor((int)direction));
    }

    public Object getRequestType() {
        return this.m_requestType;
    }

    public int getDirection() {
        return this.m_direction;
    }

    @Override
    public void deactivate() {
        this.eraseSourceFeedback();
        this.setRequest(null);
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.m_state == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            if (this.m_state == 1) {
                this.m_state = 2;
            }
        } else {
            this.m_state = 8;
            this.eraseSourceFeedback();
            this.setCommand(null);
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.m_state == 4) {
            this.m_state = 0x40000000;
            this.eraseSourceFeedback();
            this.executeCommand();
        }
        return true;
    }

    protected boolean handleDragStarted() {
        if (this.m_state == 2) {
            this.m_state = 4;
        }
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.m_state == 4) {
            this.updateRequest();
            this.showSourceFeedback();
            this.updateCommand();
        }
        return true;
    }

    public void keyDown(KeyEvent event, EditPartViewer viewer) {
        this.sendKeyRequest(true, event);
    }

    public void keyUp(KeyEvent event, EditPartViewer viewer) {
        this.sendKeyRequest(false, event);
    }

    private void sendKeyRequest(boolean pressed, KeyEvent event) {
        KeyRequest request = new KeyRequest(pressed, event);
        for (EditPart editPart : this.createOperationSet()) {
            editPart.performRequest((Request)request);
        }
    }

    @Override
    protected List<? extends EditPart> createOperationSet() {
        if (this.m_operationSet != null) {
            return this.m_operationSet;
        }
        ArrayList<? extends EditPart> operationSet = new ArrayList<EditPart>(super.createOperationSet());
        ListIterator<EditPart> I = operationSet.listIterator();
        while (I.hasNext()) {
            EditPart part = (EditPart)I.next();
            while (part != null) {
                EditPart newPart = part.getTargetEditPart((Request)this.getRequest());
                if (newPart == part) break;
                part = newPart;
            }
            if (part == null) {
                I.remove();
                continue;
            }
            I.set(part);
        }
        return operationSet;
    }

    private void updateRequest() {
        if (this.getRequest() == null) {
            this.setRequest(new ChangeBoundsRequest(this.m_requestType));
            this.getRequest().setResizeDirection(this.m_direction);
        }
        this.getRequest().setEditParts(this.getOperationSet());
        this.getRequest().setSnapToEnabled((this.m_stateMask & 0x40000) > 0);
        Point corner = new Point();
        Dimension resize = new Dimension();
        Dimension dragMoveDelta = this.getDragMoveDelta();
        if ((this.m_direction & 1) != 0) {
            corner.y += dragMoveDelta.height;
            resize.height -= dragMoveDelta.height;
        } else if ((this.m_direction & 4) != 0) {
            resize.height += dragMoveDelta.height;
        }
        if ((this.m_direction & 8) != 0) {
            corner.x += dragMoveDelta.width;
            resize.width -= dragMoveDelta.width;
        } else if ((this.m_direction & 0x10) != 0) {
            resize.width += dragMoveDelta.width;
        }
        this.getRequest().setMoveDelta(corner);
        this.getRequest().setSizeDelta(resize);
        this.getRequest().setLocation(this.getAbsoluteLocation());
    }

    @Override
    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        for (EditPart editPart : this.getOperationSet()) {
            command.add(editPart.getCommand((Request)this.getRequest()));
        }
        return command.unwrap();
    }

    protected void showSourceFeedback() {
        for (EditPart editPart : this.getOperationSet()) {
            editPart.showSourceFeedback((Request)this.getRequest());
        }
        this.setShowingFeedback(true);
    }

    protected void eraseSourceFeedback() {
        if (this.isShowingFeedback()) {
            this.setShowingFeedback(false);
            for (EditPart editPart : this.getOperationSet()) {
                editPart.eraseSourceFeedback((Request)this.getRequest());
            }
        }
    }

    protected final void setShowingFeedback(boolean isShowingFeedback) {
        this.m_isShowingFeedback = isShowingFeedback;
    }

    protected final boolean isShowingFeedback() {
        return this.m_isShowingFeedback;
    }

    private void setRequest(ChangeBoundsRequest request) {
        this.m_request = request;
    }

    protected final ChangeBoundsRequest getRequest() {
        return this.m_request;
    }
}

