/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Platform;

public final class AsyncStreamPipe {
    public Runnable pipeTo(String threadName, InputStream input, OutputStream output) {
        if (output != null) {
            BufferedInputStream bufferedInput = new BufferedInputStream(input);
            AtomicBoolean stop = new AtomicBoolean(false);
            Runnable writer = () -> {
                block4: {
                    try {
                        byte[] buffer = new byte[1024];
                        int size = 0;
                        while (!stop.get()) {
                            size = bufferedInput.read(buffer);
                            if (size > -1) {
                                output.write(buffer, 0, size);
                            }
                            if (size > -1 && !Thread.interrupted()) continue;
                            break;
                        }
                    }
                    catch (IOException ioe) {
                        if (stop.get()) break block4;
                        Platform.getLog(this.getClass()).error(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            };
            Thread writerThread = new Thread(writer, threadName);
            Runnable stopper = () -> stop.set(true);
            writerThread.setDaemon(true);
            writerThread.start();
            return stopper;
        }
        Runnable emptyRunner = () -> {};
        return emptyRunner;
    }
}

