import type { DocumentsAndMap } from '@volar/language-service/lib/utils/featureWorkers';
import type * as html from 'vscode-html-languageservice';
export interface PugDocument extends ReturnType<ReturnType<typeof register>> {
}
export declare function register(htmlLs: html.LanguageService): (pugCode: string) => {
    htmlDocument: html.HTMLDocument;
    docs: DocumentsAndMap;
    htmlCode: string;
    mappings: import("@volar/language-service").Mapping<any>[];
    pugTextDocument: html.TextDocument;
    error: {
        code: string;
        msg: string;
        line: number;
        column: number;
        filename: string;
    } | undefined;
    ast: import("./baseParse").Node | undefined;
    emptyLineEnds: number[];
};
//# sourceMappingURL=pugDocument.d.ts.map