/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.requirements;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.passage.lic.api.agreements.ResolvedAgreement;
import org.eclipse.passage.lic.api.requirements.Feature;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionLevel;

public final class BaseRequirement
implements Requirement {
    private final Feature feature;
    private final RestrictionLevel restriction;
    private final List<ResolvedAgreement> agreements;
    private final Object source;

    public BaseRequirement(Feature feature, RestrictionLevel restriction, List<ResolvedAgreement> agreements, Object source) {
        Objects.requireNonNull(feature, "Feature cannot be null on requirement definition");
        Objects.requireNonNull(restriction, "Restriction cannot be null on requirement definition. Use DefaultrestrictionLevel should the need arise");
        Objects.requireNonNull(agreements, "Agreements collection cannot be null, but can be empty");
        Objects.requireNonNull(source, "Source is mandatory for requirement definition");
        this.feature = feature;
        this.restriction = restriction;
        this.agreements = agreements;
        this.source = source;
    }

    public BaseRequirement(Feature feature, RestrictionLevel restriction, Object source) {
        this(feature, restriction, Collections.emptyList(), source);
    }

    public Feature feature() {
        return this.feature;
    }

    public RestrictionLevel restrictionLevel() {
        return this.restriction;
    }

    public Object source() {
        return this.source;
    }

    public boolean equals(Object another) {
        if (!this.getClass().isInstance(another)) {
            return false;
        }
        Requirement requirement = (Requirement)another;
        return this.feature.equals(requirement.feature()) && this.restriction.equals((Object)requirement.restrictionLevel()) && this.source.equals(requirement.source());
    }

    public int hashCode() {
        return Objects.hash(this.feature, this.restriction, this.source);
    }

    public String toString() {
        return "BaseRequirement [feature=" + String.valueOf(this.feature) + ", restriction=" + String.valueOf(this.restriction) + ", source=" + String.valueOf(this.source) + "]";
    }

    public List<ResolvedAgreement> agreements() {
        return this.agreements;
    }
}

