/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.util.concurrent.Semaphore;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class Lifecycle
extends Notifier
implements ILifecycle,
ILifecycle.DeferrableActivation {
    public static boolean USE_LABEL = true;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_LIFECYCLE, Lifecycle.class);
    private static final ContextTracer DUMPER = new ContextTracer(OM.DEBUG_LIFECYCLE_DUMP, Lifecycle.class);
    private static final boolean TRACE_IGNORING = false;
    private static final boolean LOCKING = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.lifecycle.Lifecycle.LOCKING", true);
    private LifecycleState lifecycleState = LifecycleState.INACTIVE;
    @ReflectUtil.ExcludeFromDump
    private Semaphore lifecycleSemaphore = new Semaphore(1);

    void internalActivate() throws LifecycleException {
        try {
            while (this.lifecycleState == LifecycleState.INACTIVE) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Activating " + this);
                }
                this.lock();
                if (this.lifecycleState != LifecycleState.INACTIVE) {
                    this.unlock();
                    return;
                }
                IListener[] listeners = this.getListeners();
                if (listeners.length != 0) {
                    this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ABOUT_TO_ACTIVATE), listeners);
                }
                this.doBeforeActivate();
                this.lifecycleState = LifecycleState.ACTIVATING;
                try {
                    this.doActivate();
                }
                catch (LifecycleUtil.ReactivationTrigger trigger) {
                    if (trigger.isFor(this)) {
                        this.lifecycleState = LifecycleState.INACTIVE;
                        continue;
                    }
                    throw trigger;
                }
                if (!this.isDeferredActivation()) {
                    try {
                        this.deferredActivate(true);
                    }
                    catch (LifecycleUtil.ReactivationTrigger trigger) {
                        if (trigger.isFor(this)) {
                            this.doBeforeDeactivate();
                            this.lifecycleState = LifecycleState.DEACTIVATING;
                            this.doDeactivate();
                            this.lifecycleState = LifecycleState.INACTIVE;
                            this.unlock();
                            continue;
                        }
                        throw trigger;
                    }
                }
                this.dump();
                break;
            }
        }
        catch (Error | RuntimeException ex) {
            this.deferredActivate(false);
            throw ex;
        }
        catch (Throwable ex) {
            this.deferredActivate(false);
            throw new LifecycleException(ex);
        }
    }

    Exception internalDeactivate() {
        block10: {
            boolean locked;
            block11: {
                locked = false;
                if (this.lifecycleState != LifecycleState.ACTIVE) break block10;
                if (TRACER.isEnabled()) {
                    TRACER.trace("Deactivating " + this);
                }
                locked = this.lock();
                if (this.lifecycleState == LifecycleState.ACTIVE) break block11;
                if (locked) {
                    this.unlock();
                    locked = false;
                }
                return null;
            }
            try {
                this.doBeforeDeactivate();
                IListener[] listeners = this.getListeners();
                if (listeners.length != 0) {
                    this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ABOUT_TO_DEACTIVATE), listeners);
                }
                this.lifecycleState = LifecycleState.DEACTIVATING;
                this.doDeactivate();
                this.lifecycleState = LifecycleState.INACTIVE;
                if (locked) {
                    this.unlock();
                    locked = false;
                }
                if ((listeners = this.getListeners()).length != 0) {
                    this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.DEACTIVATED), listeners);
                }
                return null;
            }
            catch (Error | Exception ex) {
                this.lifecycleState = LifecycleState.INACTIVE;
                if (locked) {
                    this.unlock();
                }
                if (ex instanceof Exception) {
                    return (Exception)ex;
                }
                throw (Error)ex;
            }
        }
        return null;
    }

    @Override
    public final void activate() throws LifecycleException {
        this.internalActivate();
    }

    @Override
    public final Exception deactivate() {
        return this.internalDeactivate();
    }

    @Override
    public final LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    public final boolean isActive() {
        return this.lifecycleState == LifecycleState.ACTIVE;
    }

    public String toString() {
        if (USE_LABEL) {
            return ReflectUtil.getLabel(this);
        }
        return super.toString();
    }

    protected final void dump() {
        if (DUMPER.isEnabled()) {
            DUMPER.trace("DUMP" + ReflectUtil.toString(this));
        }
    }

    protected final void checkActive() {
        LifecycleUtil.checkActive(this);
    }

    protected final void checkInactive() {
        LifecycleUtil.checkInactive(this);
    }

    protected final void checkNull(Object handle, String msg) throws NullPointerException {
        CheckUtil.checkNull(handle, msg);
    }

    protected final void checkArg(boolean expr, String msg) throws IllegalArgumentException {
        CheckUtil.checkArg(expr, msg);
    }

    protected final void checkArg(Object handle, String handleName) throws IllegalArgumentException {
        CheckUtil.checkState(handle, handleName);
    }

    protected final void checkState(boolean expr, String msg) throws IllegalStateException {
        CheckUtil.checkState(expr, msg);
    }

    protected final void checkState(Object handle, String handleName) throws IllegalStateException {
        CheckUtil.checkState(handle, handleName);
    }

    protected final void deferredActivate(boolean successful) {
        if (successful) {
            this.lifecycleState = LifecycleState.ACTIVE;
            try {
                this.doAfterActivate();
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
                this.deactivate();
                return;
            }
            this.unlock();
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ACTIVATED), listeners);
            }
        } else {
            this.lifecycleState = LifecycleState.INACTIVE;
            this.unlock();
        }
    }

    @Override
    public boolean isDeferredActivation() {
        return false;
    }

    protected void doBeforeActivate() throws Exception {
    }

    protected void doActivate() throws Exception {
    }

    protected void doAfterActivate() throws Exception {
    }

    protected void doBeforeDeactivate() throws Exception {
    }

    protected void doDeactivate() throws Exception {
    }

    private boolean lock() {
        if (LOCKING) {
            try {
                this.lifecycleSemaphore.acquire();
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private void unlock() {
        if (LOCKING) {
            try {
                this.lifecycleSemaphore.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

