/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;

public class RefactoringScopeFactory {
    private static void addReferencingProjects(IScriptProject focus, Set<IScriptProject> projects) throws ModelException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IBuildpathEntry entry;
            IScriptProject candidate = DLTKCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferencing(IScriptProject focus, Set<IScriptProject> projects) throws CoreException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IBuildpathEntry entry;
            IScriptProject candidate = DLTKCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferenced(IScriptProject focus, Set<IScriptProject> projects) throws CoreException {
        IProject[] referencedProjects = focus.getProject().getReferencedProjects();
        int i = 0;
        while (i < referencedProjects.length) {
            IBuildpathEntry entry;
            IScriptProject candidate = DLTKCore.create((IProject)referencedProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(focus, candidate)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                }
            }
            ++i;
        }
    }

    public static IDLTKSearchScope create(IModelElement modelElement) throws ModelException {
        return RefactoringScopeFactory.create(modelElement, true, true);
    }

    public static IDLTKSearchScope create(IModelElement modelElement, boolean considerVisibility) throws ModelException {
        return RefactoringScopeFactory.create(modelElement, considerVisibility, true);
    }

    public static IDLTKSearchScope create(IModelElement modelElement, boolean considerVisibility, boolean sourceReferencesOnly) throws ModelException {
        boolean cfr_ignored_0 = modelElement instanceof IMember;
        IScriptProject modelProject = modelElement.getScriptProject();
        return SearchEngine.createSearchScope((IModelElement[])RefactoringScopeFactory.getAllScopeElements(modelProject, sourceReferencesOnly), (boolean)false, (IDLTKLanguageToolkit)modelProject.getLanguageToolkit());
    }

    public static IDLTKSearchScope create(IMember[] members) throws ModelException {
        return RefactoringScopeFactory.create(members, true);
    }

    public static IDLTKSearchScope create(IMember[] members, boolean sourceReferencesOnly) throws ModelException {
        return RefactoringScopeFactory.create((IModelElement)members[0], true, sourceReferencesOnly);
    }

    public static IDLTKSearchScope createReferencedScope(IModelElement[] modelElements) {
        IScriptProject[] prj;
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        int i = 0;
        while (i < modelElements.length) {
            projects.add(modelElements[i].getScriptProject());
            ++i;
        }
        return SearchEngine.createSearchScope((IModelElement[])prj, (boolean)true, (prj = projects.toArray(new IScriptProject[projects.size()])).length > 0 ? prj[0].getLanguageToolkit() : null);
    }

    public static IDLTKSearchScope createReferencedScope(IModelElement[] modelElements, int includeMask) {
        IScriptProject[] prj;
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        int i = 0;
        while (i < modelElements.length) {
            projects.add(modelElements[i].getScriptProject());
            ++i;
        }
        return SearchEngine.createSearchScope((IModelElement[])prj, (boolean)true, (prj = projects.toArray(new IScriptProject[projects.size()])).length > 0 ? prj[0].getLanguageToolkit() : null);
    }

    public static IDLTKSearchScope createRelatedProjectsScope(IScriptProject project, int includeMask) throws CoreException {
        IScriptProject[] projects;
        return SearchEngine.createSearchScope((IModelElement[])projects, (boolean)true, (projects = RefactoringScopeFactory.getRelatedProjects(project)).length > 0 ? projects[0].getLanguageToolkit() : null);
    }

    private static IProjectFragment[] getAllScopeElements(IScriptProject project, boolean onlySourceRoots) throws ModelException {
        Collection<IScriptProject> referencingProjects = RefactoringScopeFactory.getReferencingProjects(project);
        ArrayList<IProjectFragment> result = new ArrayList<IProjectFragment>();
        for (IScriptProject scriptProject : referencingProjects) {
            IProjectFragment[] roots = scriptProject.getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                IProjectFragment root = roots[i];
                if (!onlySourceRoots || root.getKind() == 1) {
                    result.add(root);
                }
                ++i;
            }
        }
        return result.toArray(new IProjectFragment[result.size()]);
    }

    private static IBuildpathEntry getReferencingClassPathEntry(IScriptProject referencingProject, IScriptProject referencedProject) throws ModelException {
        IBuildpathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IBuildpathEntry[] classpath = referencingProject.getResolvedBuildpath(true);
        int i = 0;
        while (i < classpath.length) {
            IBuildpathEntry entry = classpath[i];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++i;
        }
        return result;
    }

    private static IScriptProject[] getRelatedProjects(IScriptProject focus) throws CoreException {
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        RefactoringScopeFactory.addRelatedReferencing(focus, projects);
        RefactoringScopeFactory.addRelatedReferenced(focus, projects);
        projects.add(focus);
        return projects.toArray(new IScriptProject[projects.size()]);
    }

    private static Collection<IScriptProject> getReferencingProjects(IScriptProject focus) throws ModelException {
        HashSet<IScriptProject> projects = new HashSet<IScriptProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private RefactoringScopeFactory() {
    }
}

