/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.sync;

import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.service.IGDBFocusSynchronizer;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;

public class GdbDebugContextSyncManager
implements IDebugContextListener {
    public void startup() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public void shutdown() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
    }

    public void debugContextChanged(DebugContextEvent event) {
        IDMContext dmc;
        if (event.getFlags() != 1) {
            return;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && ((dmc = (IDMContext)context.getAdapter(IDMContext.class)) instanceof IMIContainerDMContext || dmc instanceof IMIExecutionDMContext || dmc instanceof IStack.IFrameDMContext)) {
            String eventSessionId = dmc.getSessionId();
            if (!DsfSession.isSessionActive((String)eventSessionId)) {
                return;
            }
            DsfSession session = DsfSession.getSession((String)eventSessionId);
            session.getExecutor().execute(() -> {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), eventSessionId);
                IGDBFocusSynchronizer gdbSync = (IGDBFocusSynchronizer)tracker.getService(IGDBFocusSynchronizer.class);
                tracker.dispose();
                if (gdbSync != null) {
                    gdbSync.setFocus(new IDMContext[]{dmc}, (RequestMonitor)new ImmediateRequestMonitor(){

                        protected void handleFailure() {
                        }
                    });
                }
            });
        }
    }
}

