/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.servicereference;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ListAssert;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.test.assertj.bundle.BundleAssert;
import org.osgi.test.assertj.dictionary.DictionaryAssert;
import org.osgi.test.common.dictionary.Dictionaries;

public abstract class AbstractServiceReferenceAssert<SELF extends AbstractServiceReferenceAssert<SELF, ACTUAL, SERVICE>, ACTUAL extends ServiceReference<? extends SERVICE>, SERVICE>
extends AbstractComparableAssert<SELF, ACTUAL> {
    static InstanceOfAssertFactory<List, ListAssert<Bundle>> BUNDLE_LIST = InstanceOfAssertFactories.list(Bundle.class);

    protected AbstractServiceReferenceAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public DictionaryAssert<String, Object> hasServicePropertiesThat() {
        this.isNotNull();
        return DictionaryAssert.assertThat(Dictionaries.asDictionary((ServiceReference)((ServiceReference)this.actual)));
    }

    public BundleAssert isRegisteredInBundleThat() {
        return (BundleAssert)((Object)((BundleAssert)((AbstractServiceReferenceAssert)this.isNotNull()).extracting(actual -> actual.getBundle(), BundleAssert.BUNDLE)).as(this.actual + ".bundle", new Object[0]));
    }

    public ListAssert<Bundle> hasUsingBundlesThat() {
        return (ListAssert)((ListAssert)((AbstractServiceReferenceAssert)this.isNotNull()).extracting(bundleContext -> Arrays.asList(bundleContext.getUsingBundles()), BUNDLE_LIST)).as(this.actual + ".usingBundles", new Object[0]);
    }

    public SELF isRegisteredInBundle(Bundle bundle) {
        this.isNotNull();
        if (!Objects.equals(((ServiceReference)this.actual).getBundle(), bundle)) {
            throw this.failure("%nExpecting%n <%s>%nto be registered in Bundle:%n <%s>%n but it was not", new Object[]{this.actual, bundle});
        }
        return (SELF)((Object)((AbstractServiceReferenceAssert)this.myself));
    }

    public SELF isRegisteredInBundle(String bundleSymbolicName) {
        this.isNotNull();
        if (((ServiceReference)this.actual).getBundle() == null || !((ServiceReference)this.actual).getBundle().getSymbolicName().equals(bundleSymbolicName)) {
            throw this.failure("%nExpecting%n <%s>%nto be registered in Bundle with SymbolicName:%n <%s>%n but it was not", new Object[]{this.actual, bundleSymbolicName});
        }
        return (SELF)((Object)((AbstractServiceReferenceAssert)this.myself));
    }

    public SELF isRegisteredInBundle(String bundleSymbolicName, String version) {
        this.isNotNull();
        Bundle acBundle = ((ServiceReference)this.actual).getBundle();
        String bsnva = acBundle == null ? "no bundle registered" : acBundle.getSymbolicName() + ":" + acBundle.getVersion();
        String bsnvExp = bundleSymbolicName + ":" + version;
        if (acBundle == null || !acBundle.getSymbolicName().equals(bundleSymbolicName) || !acBundle.getVersion().equals((Object)Version.parseVersion((String)version))) {
            throw this.failureWithActualExpected(bsnva, bsnvExp, "%nExpecting%n <%s>%nto be registered in Bundle with SymbolicName and Version: <%s>%n but it was %s", new Object[]{this.actual, bsnvExp, bsnva});
        }
        return (SELF)((Object)((AbstractServiceReferenceAssert)this.myself));
    }

    public SELF isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(FrameworkUtil.getBundle(clazz), clazz.getName());
    }

    public SELF isAssignableTo(Bundle bundle, String className) {
        this.isNotNull();
        if (!((ServiceReference)this.actual).isAssignableTo(bundle, className)) {
            throw this.failure("%nExpecting%n <%s>%nto be assignable to:%n <%s>,<%s>%n but it was not", new Object[]{this.actual, bundle, className});
        }
        return (SELF)((Object)((AbstractServiceReferenceAssert)this.myself));
    }

    public SELF isBeingUsedBy(Bundle ... bundles) {
        ((AbstractServiceReferenceAssert)this.as("isBeingUsedBy", new Object[0])).hasUsingBundlesThat().contains((Object[])bundles);
        return (SELF)((Object)((AbstractServiceReferenceAssert)this.myself));
    }

    public SELF isBeingUsedBy(String ... bundleSymbolicNames) {
        for (String bsn : bundleSymbolicNames) {
            ((AbstractServiceReferenceAssert)this.as("isBeingUsedBy", new Object[0])).hasUsingBundlesThat().anyMatch(b -> bsn.equals(b.getSymbolicName()));
        }
        return (SELF)((Object)((AbstractServiceReferenceAssert)this.myself));
    }
}

