/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkListener;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;

public final class FrameworkListenerRegistry {
    private final Map<IFacetedProjectFrameworkEvent.Type, Set<IFacetedProjectFrameworkListener>> listeners = new EnumMap<IFacetedProjectFrameworkEvent.Type, Set<IFacetedProjectFrameworkListener>>(IFacetedProjectFrameworkEvent.Type.class);

    public FrameworkListenerRegistry() {
        IFacetedProjectFrameworkEvent.Type[] typeArray = IFacetedProjectFrameworkEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacetedProjectFrameworkEvent.Type t = typeArray[n2];
            this.listeners.put(t, new CopyOnWriteArraySet());
            ++n2;
        }
    }

    public void addListener(IFacetedProjectFrameworkListener listener, IFacetedProjectFrameworkEvent.Type ... types) {
        if (listener == null || types == null) {
            throw new IllegalArgumentException();
        }
        IFacetedProjectFrameworkEvent.Type[] typeArray = types.length > 0 ? types : IFacetedProjectFrameworkEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacetedProjectFrameworkEvent.Type type = typeArray[n2];
            this.listeners.get((Object)type).add(listener);
            ++n2;
        }
    }

    public void removeListener(IFacetedProjectFrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        for (Set<IFacetedProjectFrameworkListener> listeners : this.listeners.values()) {
            listeners.remove(listener);
        }
    }

    public void notifyListeners(IFacetedProjectFrameworkEvent event) {
        for (IFacetedProjectFrameworkListener listener : this.listeners.get((Object)event.getType())) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }

    public Set<IFacetedProjectFrameworkListener> getListeners(IFacetedProjectFrameworkEvent.Type eventType) {
        return this.listeners.get((Object)eventType);
    }
}

