/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wb.internal.core.wizards.DesignerNewElementWizard;
import org.eclipse.wb.internal.core.wizards.Messages;

public class DesignerNewProjectCreationWizardPage
extends JavaCapabilityConfigurationPage {
    private final WizardNewProjectCreationPage fMainPage;
    private IPath fCurrProjectLocation;
    protected IProject fCurrProject;
    protected boolean fCanRemoveContent;

    public DesignerNewProjectCreationWizardPage(WizardNewProjectCreationPage mainPage) {
        this.fMainPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fCanRemoveContent = false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        IProject newProjectHandle = this.fMainPage.getProjectHandle();
        IPath newProjectLocation = this.fMainPage.getLocationPath();
        this.fCanRemoveContent = this.fMainPage.useDefaults() ? !newProjectLocation.append(this.fMainPage.getProjectName()).toFile().exists() : !newProjectLocation.toFile().exists();
        final boolean initialize = !newProjectHandle.equals((Object)this.fCurrProject) || !newProjectLocation.equals((Object)this.fCurrProjectLocation);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    DesignerNewProjectCreationWizardPage.this.updateProject(initialize, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InvocationTargetException e) {
            String title = Messages.DesignerNewProjectCreationWizardPage_title;
            String message = Messages.DesignerNewProjectCreationWizardPage_message;
            DesignerNewElementWizard.ExceptionHandler.perform(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void updateProject(boolean initialize, IProgressMonitor monitor) throws CoreException, InterruptedException {
        boolean noProgressMonitor;
        this.fCurrProject = this.fMainPage.getProjectHandle();
        this.fCurrProjectLocation = this.fMainPage.getLocationPath();
        boolean bl = noProgressMonitor = !initialize && this.fCanRemoveContent;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DesignerNewProjectCreationWizardPage_createProject, (int)2);
            DesignerNewProjectCreationWizardPage.createProject((IProject)this.fCurrProject, (IPath)this.fCurrProjectLocation, (IProgressMonitor)subMonitor.split(1));
            if (initialize) {
                IClasspathEntry[] entries = null;
                IPath outputLocation = null;
                if (this.fCurrProjectLocation.toFile().exists() && !Platform.getLocation().equals((Object)this.fCurrProjectLocation) && !this.fCurrProject.getFile(".classpath").exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject);
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                }
                this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            }
            subMonitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DesignerNewProjectCreationWizardPage_updateProject, (int)3);
            if (this.fCurrProject == null) {
                this.updateProject(true, (IProgressMonitor)subMonitor.split(1));
            }
            this.configureJavaProject((IProgressMonitor)subMonitor.split(2));
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
        }
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean noProgressMonitor = Platform.getLocation().equals((Object)DesignerNewProjectCreationWizardPage.this.fCurrProjectLocation);
                if (monitor == null || noProgressMonitor) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.DesignerNewProjectCreationWizardPage_removeProgress, 3);
                try {
                    try {
                        DesignerNewProjectCreationWizardPage.this.fCurrProject.delete(DesignerNewProjectCreationWizardPage.this.fCanRemoveContent, false, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                    DesignerNewProjectCreationWizardPage.this.fCurrProject = null;
                    DesignerNewProjectCreationWizardPage.this.fCanRemoveContent = false;
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InvocationTargetException e) {
            String title = Messages.DesignerNewProjectCreationWizardPage_removeErrorTitle;
            String message = Messages.DesignerNewProjectCreationWizardPage_removeErrorMessage;
            DesignerNewElementWizard.ExceptionHandler.perform(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void performCancel() {
        this.removeProject();
    }

    private static class ClassPathDetector
    implements IResourceProxyVisitor {
        private final Map<IPath, List<IPath>> fSourceFolders = new HashMap<IPath, List<IPath>>();
        private final List<IFile> fClassFiles = new ArrayList<IFile>();
        private final Set<IPath> fJARFiles = new HashSet<IPath>();
        private final IProject fProject;
        private IPath fResultOutputFolder;
        private IClasspathEntry[] fResultClasspath;

        public ClassPathDetector(IProject project) throws CoreException {
            this.fProject = project;
            project.accept((IResourceProxyVisitor)this, 0);
            this.fResultClasspath = null;
            this.fResultOutputFolder = null;
            this.detectClasspath();
        }

        private boolean isNested(IPath path, Iterator<IPath> iter) {
            while (iter.hasNext()) {
                IPath other = iter.next();
                if (!other.isPrefixOf(path)) continue;
                return true;
            }
            return false;
        }

        private void detectClasspath() {
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
            this.detectSourceFolders(cpEntries);
            IPath outputLocation = this.detectOutputFolder(cpEntries);
            this.detectLibraries(cpEntries, outputLocation);
            if (cpEntries.isEmpty() && this.fClassFiles.isEmpty()) {
                return;
            }
            IClasspathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
            int i = 0;
            while (i < jreEntries.length) {
                cpEntries.add(jreEntries[i]);
                ++i;
            }
            IClasspathEntry[] entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
            if (!JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)this.fProject), (IClasspathEntry[])entries, (IPath)outputLocation).isOK()) {
                return;
            }
            this.fResultClasspath = entries;
            this.fResultOutputFolder = outputLocation;
        }

        private IPath findInSourceFolders(IPath path) {
            for (IPath key : this.fSourceFolders.keySet()) {
                List<IPath> cus = this.fSourceFolders.get(key);
                if (!cus.contains(path)) continue;
                return key;
            }
            return null;
        }

        private IPath detectOutputFolder(List<IClasspathEntry> entries) {
            HashSet<IPath> classFolders = new HashSet<IPath>();
            for (IFile file : this.fClassFiles) {
                IClassFileReader reader;
                IPath location = file.getLocation();
                if (location == null || (reader = ToolFactory.createDefaultClassFileReader((String)location.toOSString(), (int)17)) == null) continue;
                char[] className = reader.getClassName();
                ISourceAttribute sourceAttribute = reader.getSourceFileAttribute();
                if (className == null || sourceAttribute == null || sourceAttribute.getSourceFileName() == null) continue;
                IPath packPath = file.getParent().getFullPath();
                int idx = CharOperation.lastIndexOf((char)'/', (char[])className) + 1;
                Path relPath = new Path(new String(className, 0, idx));
                IPath cuPath = relPath.append(new String(sourceAttribute.getSourceFileName()));
                IPath resPath = null;
                if (idx == 0) {
                    resPath = packPath;
                } else {
                    IPath folderPath = this.getFolderPath(packPath, (IPath)relPath);
                    if (folderPath != null) {
                        resPath = folderPath;
                    }
                }
                if (resPath == null) continue;
                IPath path = this.findInSourceFolders(cuPath);
                if (path != null) {
                    return resPath;
                }
                classFolders.add(resPath);
            }
            IPath projPath = this.fProject.getFullPath();
            if (this.fSourceFolders.size() == 1 && classFolders.isEmpty() && this.fSourceFolders.get(projPath) != null) {
                return projPath;
            }
            IPath path = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
            while (classFolders.contains(path)) {
                path = new Path(path.toString() + "1");
            }
            return path;
        }

        private void detectLibraries(List<IClasspathEntry> cpEntries, IPath outputLocation) {
            Set<IPath> sourceFolderSet = this.fSourceFolders.keySet();
            for (IPath path : this.fJARFiles) {
                if (this.isNested(path, sourceFolderSet.iterator()) || outputLocation != null && outputLocation.isPrefixOf(path)) continue;
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
                cpEntries.add(entry);
            }
        }

        private void detectSourceFolders(List<IClasspathEntry> resEntries) {
            Set<IPath> sourceFolderSet = this.fSourceFolders.keySet();
            for (IPath path : sourceFolderSet) {
                ArrayList<IPath> excluded = new ArrayList<IPath>();
                for (IPath other : sourceFolderSet) {
                    if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
                    IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                    excluded.add(pathToExclude);
                }
                IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
                IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
                resEntries.add(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitCompilationUnit(IFile file) throws JavaModelException {
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
            if (cu != null) {
                ICompilationUnit workingCopy = null;
                try {
                    ICompilationUnit iCompilationUnit = workingCopy = (ICompilationUnit)cu.getWorkingCopy();
                    synchronized (iCompilationUnit) {
                        workingCopy.reconcile();
                    }
                    IPath packPath = file.getParent().getFullPath();
                    IPackageDeclaration[] decls = workingCopy.getPackageDeclarations();
                    String cuName = file.getName();
                    if (decls.length == 0) {
                        this.addToMap(this.fSourceFolders, packPath, (IPath)new Path(cuName));
                    } else {
                        Path relpath = new Path(decls[0].getElementName().replace('.', '/'));
                        IPath folderPath = this.getFolderPath(packPath, (IPath)relpath);
                        if (folderPath != null) {
                            this.addToMap(this.fSourceFolders, folderPath, relpath.append(cuName));
                        }
                    }
                }
                finally {
                    if (workingCopy != null) {
                        workingCopy.destroy();
                    }
                }
            }
        }

        private void addToMap(Map<IPath, List<IPath>> map, IPath folderPath, IPath relPath) {
            List<IPath> list = map.get(folderPath);
            if (list == null) {
                list = new ArrayList<IPath>(50);
                map.put(folderPath, list);
            }
            list.add(relPath);
        }

        private IPath getFolderPath(IPath packPath, IPath relpath) {
            IPath common;
            int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
            if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals((Object)relpath)) {
                return packPath.uptoSegment(remainingSegments);
            }
            return null;
        }

        private boolean hasExtension(String name, String ext) {
            return name.endsWith(ext) && ext.length() != name.length();
        }

        private boolean isValidCUName(String name) {
            return !JavaConventions.validateCompilationUnitName((String)name).matches(4);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1) {
                String name = proxy.getName();
                if (this.hasExtension(name, ".java") && this.isValidCUName(name)) {
                    this.visitCompilationUnit((IFile)proxy.requestResource());
                } else if (this.hasExtension(name, ".class")) {
                    this.fClassFiles.add((IFile)proxy.requestResource());
                } else if (this.hasExtension(name, ".jar")) {
                    this.fJARFiles.add(proxy.requestFullPath());
                }
                return false;
            }
            return true;
        }

        public IPath getOutputLocation() {
            return this.fResultOutputFolder;
        }

        public IClasspathEntry[] getClasspath() {
            return this.fResultClasspath;
        }
    }
}

