/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data;

import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.helper.SiriusDiagramHelper;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.ILostElementDataContainer;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataState;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataUtil;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataWithMapping;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class LostNodeData
extends LostElementDataWithMapping
implements ILostElementDataContainer {
    private ILostElementDataContainer parentData;

    public void setParentData(ILostElementDataContainer parentData) {
        this.parentData = parentData;
    }

    public ILostElementDataContainer getParentData() {
        return this.parentData;
    }

    @Override
    protected LostElementDataState doRecreateNonExistingLostElement(DSemanticDiagram designerDiagram) {
        LostElementDataState created = super.doRecreateNonExistingLostElement(designerDiagram);
        DDiagramElement createdElement = SiriusDiagramHelper.createElement(this.getMapping(), designerDiagram, this.getTarget());
        if (createdElement != null) {
            if (this.parentData == null) {
                if (designerDiagram.getOwnedDiagramElements().add((Object)createdElement)) {
                    created = LostElementDataState.CREATED;
                }
            } else {
                created = this.parentData.addDiagramElementInCorrespondingParentContainer((DDiagram)designerDiagram, createdElement);
            }
        }
        return created;
    }

    @Override
    public String toString() {
        String result = super.toString() + " |--| ";
        result = this.parentData == null ? result + "no parent data" : result + "Parent data: " + this.parentData.toString();
        return result;
    }

    @Override
    protected boolean doIsSimilarTo(DDiagramElement diagramElement, RepresentationElementMapping extractedMapping) {
        boolean result = false;
        if (super.doIsSimilarTo(diagramElement, extractedMapping)) {
            if (this.parentData == null) {
                result = true;
            } else if (diagramElement.eContainer() instanceof DSemanticDecorator) {
                result = this.parentData.isSimilarTo((DSemanticDecorator)diagramElement.eContainer());
            }
        }
        return result;
    }

    @Override
    public LostElementDataState addDiagramElementInCorrespondingParentContainer(DDiagram designerDiagram, DDiagramElement createdElement) {
        LostElementDataState result = LostElementDataState.NOT_CREATED;
        DDiagramElement parentVPContainer = LostElementDataUtil.findDesignerDiagramElement(designerDiagram, this);
        if (parentVPContainer instanceof AbstractDNode) {
            AbstractDNode otherAbstractNode = (AbstractDNode)parentVPContainer;
            boolean created = false;
            RepresentationElementMapping mapping = otherAbstractNode.getMapping();
            if (createdElement instanceof DNode && mapping instanceof AbstractNodeMapping && MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)((AbstractNodeMapping)mapping)).contains((Object)createdElement.getMapping())) {
                created = otherAbstractNode.getOwnedBorderedNodes().add((Object)((DNode)createdElement));
            } else if (parentVPContainer instanceof DNodeContainer) {
                created = ((DNodeContainer)parentVPContainer).getOwnedDiagramElements().add((Object)createdElement);
            } else if (parentVPContainer instanceof DNodeList) {
                created = ((DNodeList)parentVPContainer).getOwnedElements().add((Object)((DNodeListElement)createdElement));
            }
            if (created) {
                result = LostElementDataState.CREATED;
            }
        }
        return result;
    }
}

