/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandSubstitutor;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemPromptCompileCommandDialog;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SystemCompilableSource
implements Runnable {
    protected Object firstSelection;
    protected boolean isPrompt;
    protected SystemCompileCommand compileCmd;
    protected ISystemRemoteElementAdapter rmtAdapter;
    protected Shell shell;
    protected Viewer viewer;

    public SystemCompilableSource(Shell shell, Object firstSelection, SystemCompileCommand compileCmd, boolean isPrompt, Viewer viewer) {
        this.shell = shell;
        this.firstSelection = firstSelection;
        this.compileCmd = compileCmd;
        this.isPrompt = isPrompt;
        this.rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)firstSelection);
        this.viewer = viewer;
    }

    public Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        this.shell = SystemBasePlugin.getActiveWorkbenchShell();
        if (this.shell == null) {
            this.shell = Display.getCurrent().getActiveShell();
            if (this.shell == null) {
                Shell[] shells = Display.getCurrent().getShells();
                int i = 0;
                while (i < shells.length && this.shell == null) {
                    if (!shells[i].isDisposed() && shells[i].isEnabled()) {
                        this.shell = shells[i];
                    }
                    ++i;
                }
            }
        }
        return this.shell;
    }

    protected Object getSelectedObject() {
        return this.firstSelection;
    }

    protected SystemCompileCommand getCompileCommand() {
        return this.compileCmd;
    }

    protected boolean isPrompt() {
        return this.isPrompt;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter() {
        return this.rmtAdapter;
    }

    public String getSourceType() {
        return this.rmtAdapter.getRemoteSourceType(this.firstSelection);
    }

    public IHost getSystemConnection() {
        return this.getSubSystem().getHost();
    }

    protected ISubSystem getSubSystem() {
        return this.rmtAdapter.getSubSystem(this.firstSelection);
    }

    protected IRemoteCmdSubSystem getCommandSubSystem() {
        return RemoteCommandHelpers.getCmdSubSystem((IHost)this.getSubSystem().getHost());
    }

    protected SystemCmdSubstVarList getSubstitutionVariableList() {
        SystemCompileManager mgr = this.compileCmd.getParentType().getParentProfile().getParentManager();
        mgr.setCurrentCompileCommand(this.compileCmd);
        SystemCmdSubstVarList varlist = mgr.getSubstitutionVariableList();
        mgr.setCurrentCompileCommand(null);
        return varlist;
    }

    protected ISystemCompileCommandSubstitutor getSubstitutor() {
        SystemCompileManager mgr = this.compileCmd.getParentType().getParentProfile().getParentManager();
        mgr.setCurrentCompileCommand(this.compileCmd);
        if (mgr.getSystemConnection() == null) {
            mgr.setSystemConnection(this.getSystemConnection());
        }
        ISystemCompileCommandSubstitutor substitutor = this.compileCmd.getParentType().getParentProfile().getParentManager().getSubstitutor();
        mgr.setCurrentCompileCommand(null);
        return substitutor;
    }

    public boolean runCompileCommand() {
        String substitutedString = this.getSubstitutedString(this.compileCmd, this.firstSelection, this.getSubstitutor());
        if (this.isPrompt() && ((substitutedString = this.internalPromptCompileCommand(substitutedString)) == null || substitutedString.trim().equals(""))) {
            return false;
        }
        return this.internalRunCompileCommand(substitutedString);
    }

    protected String getSubstitutedString(SystemCompileCommand compileCmd, Object firstSelection, ISystemCompileCommandSubstitutor substitutor) {
        return compileCmd.doVariableSubstitution(firstSelection, substitutor);
    }

    protected boolean internalRunCompileCommand(String compileCmd) {
        return true;
    }

    protected String internalPromptCompileCommand(String substitutedCompileCommand) {
        String promptedCmd = substitutedCompileCommand;
        SystemPromptCompileCommandDialog promptDlg = new SystemPromptCompileCommandDialog(this.shell, substitutedCompileCommand);
        promptDlg.open();
        promptedCmd = !promptDlg.wasCancelled() ? promptDlg.getCommand() : null;
        return promptedCmd;
    }

    public void run() {
    }
}

