/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExternalBreakpointActionHelper {
    private static String getSecondaryId(ITextEditor textEditor) {
        IModelElement modelElement;
        String secondaryId = null;
        if (textEditor instanceof PHPStructuredEditor && (modelElement = ((PHPStructuredEditor)textEditor).getModelElement()) instanceof IExternalSourceModule) {
            secondaryId = EnvironmentPathUtils.getFile((IModelElement)modelElement).getFullPath().toString();
        }
        return secondaryId;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasMarkers(ITextEditor textEditor, IResource resource, IDocument document, AbstractMarkerAnnotationModel annotationModel, IVerticalRulerInfo rulerInfo) {
        if (resource != null && annotationModel != null) {
            try {
                if (resource instanceof IFile && resource.exists()) {
                    IMarker[] allMarkers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    if (allMarkers != null) {
                        IMarker[] iMarkerArray = allMarkers;
                        int n = allMarkers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            if (ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(marker), document, rulerInfo)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                } else {
                    String secondaryId = ExternalBreakpointActionHelper.getSecondaryId(textEditor);
                    IMarker[] allMarkers = resource.getWorkspace().getRoot().findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                    if (allMarkers != null) {
                        IMarker[] iMarkerArray = allMarkers;
                        int n = allMarkers.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IMarker marker = iMarkerArray[n3];
                            if (manager.getBreakpoint(marker) != null) {
                                String markerSecondaryId = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", null);
                                if ((secondaryId == null || secondaryId.equals(markerSecondaryId)) && ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(marker), document, rulerInfo)) {
                                    return true;
                                }
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static IMarker[] getMarkers(ITextEditor textEditor, IResource resource, IDocument document, AbstractMarkerAnnotationModel annotationModel, IVerticalRulerInfo rulerInfo) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        if (resource != null && annotationModel != null) {
            try {
                if (resource instanceof IFile && resource.exists()) {
                    IMarker[] allMarkers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                    if (allMarkers != null) {
                        IMarker[] iMarkerArray = allMarkers;
                        int n = allMarkers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            if (ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(marker), document, rulerInfo)) {
                                markers.add(marker);
                            }
                            ++n2;
                        }
                    }
                } else {
                    String secondaryId = ExternalBreakpointActionHelper.getSecondaryId(textEditor);
                    IMarker[] allMarkers = resource.getWorkspace().getRoot().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                    if (allMarkers != null) {
                        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                        IMarker[] iMarkerArray = allMarkers;
                        int n = allMarkers.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IMarker marker = iMarkerArray[n3];
                            if (manager.getBreakpoint(marker) != null) {
                                String markerSecondaryId = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", null);
                                if ((secondaryId == null || secondaryId.equals(markerSecondaryId)) && ExternalBreakpointActionHelper.includesRulerLine(annotationModel.getMarkerPosition(marker), document, rulerInfo)) {
                                    markers.add(marker);
                                }
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return markers.toArray(new IMarker[0]);
    }

    private static boolean includesRulerLine(Position position, IDocument document, IVerticalRulerInfo rulerInfo) {
        if (position != null && rulerInfo != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = rulerInfo.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }
}

