/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.diagnostic;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.diagnostic.RequirementStatus;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;

public final class RequirementsCoverage
implements Supplier<List<RequirementStatus>> {
    private final ExaminationCertificate certificate;

    public RequirementsCoverage(ExaminationCertificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public List<RequirementStatus> get() {
        return new SumOfLists<RequirementStatus>().apply(this.restrictions(), this.satisfactions());
    }

    private List<RequirementStatus> restrictions() {
        return this.certificate.restrictions().stream().map(RequirementStatus::new).collect(Collectors.toList());
    }

    private List<RequirementStatus> satisfactions() {
        return this.certificate.satisfied().stream().map(RequirementStatus::new).collect(Collectors.toList());
    }
}

