/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.deltaPropagation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.opposites.ExtentMap;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.PartialEcoreEnvironmentFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.EcoreEnvironmentFactoryWithScopedExtentMap;
import org.eclipse.ocl.examples.impactanalyzer.util.EcoreEvaluationEnvironmentWithScopedExtentMap;
import org.eclipse.ocl.expressions.VariableExp;

public class PartialEcoreEvaluationEnvironment
extends EcoreEvaluationEnvironmentWithScopedExtentMap {
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final Object valueOfSourceExpression;

    public PartialEcoreEvaluationEnvironment(PartialEcoreEnvironmentFactory factory, Object valueOfSourceExpression) {
        super((EcoreEnvironmentFactoryWithScopedExtentMap)factory);
        this.valueOfSourceExpression = valueOfSourceExpression;
    }

    public PartialEcoreEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
        this.valueOfSourceExpression = ((PartialEcoreEvaluationEnvironment)parent).valueOfSourceExpression;
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object context) {
        if (context != null || !(this.valueOfSourceExpression instanceof Notifier)) {
            return super.createExtentMap(context);
        }
        return new ExtentMap((Notifier)this.valueOfSourceExpression, this.getFactory().getOppositeEndFinder());
    }

    public Object getValueOf(String name) {
        if (!this.map.containsKey(name)) {
            throw new ValueNotFoundException(name);
        }
        return this.map.get(name);
    }

    public Object getValueOf(VariableExp<EClassifier, EParameter> v) {
        String name = v.getReferredVariable().getName();
        if (!this.map.containsKey(name)) {
            throw new ValueNotFoundException(name, v);
        }
        return this.map.get(name);
    }

    public void replace(String name, Object value) {
        this.map.put(name, value);
    }

    public void add(String name, Object value) {
        if (this.map.containsKey(name)) {
            String message = "The name: " + name + " already has a binding: " + this.map.get(name);
            throw new IllegalArgumentException(message);
        }
        if (!"self".equals(name) || value != null) {
            this.map.put(name, value);
        }
    }

    public Object remove(String name) {
        return this.map.remove(name);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

