/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.SimpleTclSourceViewerConfiguration;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.templates.TemplateVariableProcessor;
import org.eclipse.dltk.ui.text.templates.TemplateVariableTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeTemplateTclSourceViewerConfiguration
extends SimpleTclSourceViewerConfiguration {
    private final TemplateVariableProcessor fProcessor;

    public CodeTemplateTclSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore store, ITextEditor editor, TemplateVariableProcessor processor) {
        super(colorManager, store, editor, "__tcl_partitioning", false);
        this.fProcessor = processor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = TclUI.getDefault().getPreferenceStore();
        TclTextTools textTools = TclUI.getDefault().getTextTools();
        IColorManager manager = textTools.getColorManager();
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__tcl_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__tcl_comment");
        assistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
        assistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
        assistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(parent -> new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString()));
        Color background = this.getColor(store, "content_assist_parameters_background", manager);
        assistant.setContextInformationPopupBackground(background);
        assistant.setContextSelectorBackground(background);
        Color foreground = this.getColor(store, "content_assist_parameters_foreground", manager);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextSelectorForeground(foreground);
        return assistant;
    }

    private Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    @Override
    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new TemplateVariableTextHover(this.fProcessor);
    }
}

