/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.strategy.mutable;

import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.factory.set.strategy.MutableHashingStrategySetFactory;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableHashingStrategySetFactoryImpl implements MutableHashingStrategySetFactory
{
    INSTANCE;


    public <T> MutableSet<T> of(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    public <T> MutableSet<T> with(HashingStrategy<? super T> hashingStrategy) {
        return UnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, new Object[0]);
    }

    public <T> MutableSet<T> of(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return this.with(hashingStrategy, items);
    }

    public <T> MutableSet<T> with(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return UnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, items);
    }

    public <T> MutableSet<T> ofAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.withAll(hashingStrategy, items);
    }

    public <T> MutableSet<T> withAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        if (Iterate.isEmpty(items)) {
            return this.with(hashingStrategy);
        }
        return UnifiedSetWithHashingStrategy.newSet(hashingStrategy, items);
    }

    public <T> MutableSet<T> ofInitialCapacity(HashingStrategy<? super T> hashingStrategy, int capacity) {
        return this.withInitialCapacity(hashingStrategy, capacity);
    }

    public <T> MutableSet<T> withInitialCapacity(HashingStrategy<? super T> hashingStrategy, int capacity) {
        return UnifiedSetWithHashingStrategy.newSet(hashingStrategy, capacity);
    }
}

