/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.AbstractMemoryOverflowModel;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbSailStore;
import org.eclipse.rdf4j.sail.lmdb.SailSourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MemoryOverflowModel
extends AbstractMemoryOverflowModel<SailSourceModel> {
    final Logger logger = LoggerFactory.getLogger(MemoryOverflowModel.class);
    private transient File dataDir;
    private transient LmdbSailStore store;

    public MemoryOverflowModel(boolean verifyAdditions) {
    }

    protected abstract LmdbSailStore createSailStore(File var1) throws IOException, SailException;

    @Override
    protected void overflowToDiskInner(Model memory) {
        try {
            assert (this.disk == null);
            this.dataDir = Files.createTempDirectory("model", new FileAttribute[0]).toFile();
            this.logger.debug("memory overflow using temp directory {}", (Object)this.dataDir);
            this.store = this.createSailStore(this.dataDir);
            this.disk = new SailSourceModel(this.store, memory){

                protected void finalize() throws Throwable {
                    MemoryOverflowModel.this.logger.debug("finalizing {}", (Object)MemoryOverflowModel.this.dataDir);
                    if (MemoryOverflowModel.this.disk == this) {
                        try {
                            MemoryOverflowModel.this.store.close();
                        }
                        catch (SailException e) {
                            MemoryOverflowModel.this.logger.error(e.toString(), (Throwable)e);
                        }
                        finally {
                            FileUtil.deleteDir(MemoryOverflowModel.this.dataDir);
                            MemoryOverflowModel.this.dataDir = null;
                            MemoryOverflowModel.this.store = null;
                            MemoryOverflowModel.this.disk = null;
                        }
                    }
                    super.finalize();
                }
            };
        }
        catch (IOException | SailException e) {
            String path = this.dataDir != null ? this.dataDir.getAbsolutePath() : "(unknown)";
            this.logger.error("Error while writing to overflow directory " + path, (Throwable)e);
        }
    }
}

