/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreSchema;

public class NativeStoreConfig
extends BaseSailConfig {
    private String tripleIndexes;
    private boolean forceSync = false;
    private int valueCacheSize = -1;
    private int valueIDCacheSize = -1;
    private int namespaceCacheSize = -1;
    private int namespaceIDCacheSize = -1;
    private long walMaxSegmentBytes = -1L;
    private int walQueueCapacity = -1;
    private int walBatchBufferBytes = -1;
    private String walSyncPolicy;
    private long walSyncIntervalMillis = -1L;
    private long walIdlePollIntervalMillis = -1L;
    private String walDirectoryName;
    private boolean walSyncBootstrapOnOpen = false;
    private boolean walAutoRecoverOnOpen = false;
    private boolean walEnabled = true;

    public NativeStoreConfig() {
        super("openrdf:NativeStore");
    }

    public NativeStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public NativeStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public int getValueCacheSize() {
        return this.valueCacheSize;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public int getValueIDCacheSize() {
        return this.valueIDCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public int getNamespaceCacheSize() {
        return this.namespaceCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public int getNamespaceIDCacheSize() {
        return this.namespaceIDCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    public long getWalMaxSegmentBytes() {
        return this.walMaxSegmentBytes;
    }

    public void setWalMaxSegmentBytes(long walMaxSegmentBytes) {
        this.walMaxSegmentBytes = walMaxSegmentBytes;
    }

    public int getWalQueueCapacity() {
        return this.walQueueCapacity;
    }

    public void setWalQueueCapacity(int walQueueCapacity) {
        this.walQueueCapacity = walQueueCapacity;
    }

    public int getWalBatchBufferBytes() {
        return this.walBatchBufferBytes;
    }

    public void setWalBatchBufferBytes(int walBatchBufferBytes) {
        this.walBatchBufferBytes = walBatchBufferBytes;
    }

    public String getWalSyncPolicy() {
        return this.walSyncPolicy;
    }

    public void setWalSyncPolicy(String walSyncPolicy) {
        this.walSyncPolicy = walSyncPolicy;
    }

    public long getWalSyncIntervalMillis() {
        return this.walSyncIntervalMillis;
    }

    public void setWalSyncIntervalMillis(long walSyncIntervalMillis) {
        this.walSyncIntervalMillis = walSyncIntervalMillis;
    }

    public long getWalIdlePollIntervalMillis() {
        return this.walIdlePollIntervalMillis;
    }

    public void setWalIdlePollIntervalMillis(long walIdlePollIntervalMillis) {
        this.walIdlePollIntervalMillis = walIdlePollIntervalMillis;
    }

    public String getWalDirectoryName() {
        return this.walDirectoryName;
    }

    public void setWalDirectoryName(String walDirectoryName) {
        this.walDirectoryName = walDirectoryName;
    }

    public boolean getWalSyncBootstrapOnOpen() {
        return this.walSyncBootstrapOnOpen;
    }

    public void setWalSyncBootstrapOnOpen(boolean walSyncBootstrapOnOpen) {
        this.walSyncBootstrapOnOpen = walSyncBootstrapOnOpen;
    }

    public boolean getWalAutoRecoverOnOpen() {
        return this.walAutoRecoverOnOpen;
    }

    public void setWalAutoRecoverOnOpen(boolean walAutoRecoverOnOpen) {
        this.walAutoRecoverOnOpen = walAutoRecoverOnOpen;
    }

    public boolean getWalEnabled() {
        return this.walEnabled;
    }

    public void setWalEnabled(boolean walEnabled) {
        this.walEnabled = walEnabled;
    }

    @Override
    public Resource export(Model m) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(m);
        }
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        if (this.tripleIndexes != null) {
            m.add(implNode, CONFIG.Native.tripleIndexes, Values.literal(this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            m.add(implNode, CONFIG.Native.forceSync, Values.literal(this.forceSync), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.valueCacheSize, Values.literal(this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.valueIDCacheSize, Values.literal(this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.namespaceCacheSize, Values.literal(this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.namespaceIDCacheSize, Values.literal(this.namespaceIDCacheSize), new Resource[0]);
        }
        if (this.walMaxSegmentBytes >= 0L) {
            m.add(implNode, CONFIG.Native.walMaxSegmentBytes, Values.literal(this.walMaxSegmentBytes), new Resource[0]);
        }
        if (this.walQueueCapacity > 0) {
            m.add(implNode, CONFIG.Native.walQueueCapacity, Values.literal(this.walQueueCapacity), new Resource[0]);
        }
        if (this.walBatchBufferBytes > 0) {
            m.add(implNode, CONFIG.Native.walBatchBufferBytes, Values.literal(this.walBatchBufferBytes), new Resource[0]);
        }
        if (this.walSyncPolicy != null) {
            m.add(implNode, CONFIG.Native.walSyncPolicy, Values.literal(this.walSyncPolicy), new Resource[0]);
        }
        if (this.walSyncIntervalMillis >= 0L) {
            m.add(implNode, CONFIG.Native.walSyncIntervalMillis, Values.literal(this.walSyncIntervalMillis), new Resource[0]);
        }
        if (this.walIdlePollIntervalMillis >= 0L) {
            m.add(implNode, CONFIG.Native.walIdlePollIntervalMillis, Values.literal(this.walIdlePollIntervalMillis), new Resource[0]);
        }
        if (this.walDirectoryName != null) {
            m.add(implNode, CONFIG.Native.walDirectoryName, Values.literal(this.walDirectoryName), new Resource[0]);
        }
        if (this.walSyncBootstrapOnOpen) {
            m.add(implNode, CONFIG.Native.walSyncBootstrapOnOpen, Values.literal(true), new Resource[0]);
        }
        if (this.walAutoRecoverOnOpen) {
            m.add(implNode, CONFIG.Native.walAutoRecoverOnOpen, Values.literal(true), new Resource[0]);
        }
        if (!this.walEnabled) {
            m.add(implNode, CONFIG.Native.walEnabled, Values.literal(false), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("ns", "http://www.openrdf.org/config/sail/native#");
        if (this.tripleIndexes != null) {
            m.add(implNode, NativeStoreSchema.TRIPLE_INDEXES, Values.literal(this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            m.add(implNode, NativeStoreSchema.FORCE_SYNC, Values.literal(this.forceSync), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.VALUE_CACHE_SIZE, Values.literal(this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.VALUE_ID_CACHE_SIZE, Values.literal(this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.NAMESPACE_CACHE_SIZE, Values.literal(this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE, Values.literal(this.namespaceIDCacheSize), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.tripleIndexes, NativeStoreSchema.TRIPLE_INDEXES).ifPresent(lit -> this.setTripleIndexes(lit.getLabel()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.forceSync, NativeStoreSchema.FORCE_SYNC).ifPresent(lit -> {
                try {
                    this.setForceSync(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + String.valueOf(CONFIG.Native.forceSync) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.valueCacheSize, NativeStoreSchema.VALUE_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setValueCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.valueCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.valueIDCacheSize, NativeStoreSchema.VALUE_ID_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setValueIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.valueIDCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.namespaceCacheSize, NativeStoreSchema.NAMESPACE_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setNamespaceCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.namespaceCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.namespaceIDCacheSize, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setNamespaceIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.namespaceIDCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walMaxSegmentBytes).ifPresent(lit -> {
                try {
                    this.setWalMaxSegmentBytes(lit.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long value required for " + String.valueOf(CONFIG.Native.walMaxSegmentBytes) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walQueueCapacity).ifPresent(lit -> {
                try {
                    this.setWalQueueCapacity(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.walQueueCapacity) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walBatchBufferBytes).ifPresent(lit -> {
                try {
                    this.setWalBatchBufferBytes(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.walBatchBufferBytes) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walSyncPolicy).ifPresent(lit -> this.setWalSyncPolicy(lit.getLabel()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walSyncIntervalMillis).ifPresent(lit -> {
                try {
                    this.setWalSyncIntervalMillis(lit.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long value required for " + String.valueOf(CONFIG.Native.walSyncIntervalMillis) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walIdlePollIntervalMillis).ifPresent(lit -> {
                try {
                    this.setWalIdlePollIntervalMillis(lit.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long value required for " + String.valueOf(CONFIG.Native.walIdlePollIntervalMillis) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walDirectoryName).ifPresent(lit -> this.setWalDirectoryName(lit.getLabel()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walSyncBootstrapOnOpen).ifPresent(lit -> {
                try {
                    this.setWalSyncBootstrapOnOpen(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + String.valueOf(CONFIG.Native.walSyncBootstrapOnOpen) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walAutoRecoverOnOpen).ifPresent(lit -> {
                try {
                    this.setWalAutoRecoverOnOpen(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + String.valueOf(CONFIG.Native.walAutoRecoverOnOpen) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.walEnabled).ifPresent(lit -> {
                try {
                    this.setWalEnabled(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + String.valueOf(CONFIG.Native.walEnabled) + " property, found " + String.valueOf(lit));
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

