/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.deseralization;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.deseralization.ListToRdf;
import no.hasmac.jsonld.flattening.NodeMap;
import no.hasmac.jsonld.json.JsonCanonicalizer;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.BlankNode;
import no.hasmac.jsonld.lang.LanguageTag;
import no.hasmac.jsonld.lang.ListObject;
import no.hasmac.jsonld.lang.NodeObject;
import no.hasmac.jsonld.lang.ValueObject;
import no.hasmac.jsonld.uri.UriUtils;
import no.hasmac.rdf.RdfValueFactory;

final class ObjectToRdf<Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> {
    private static final Logger LOGGER = Logger.getLogger(ObjectToRdf.class.getName());
    private static final DecimalFormat xsdNumberFormat = new DecimalFormat("0.0##############E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory;
    private final JsonLdOptions options;
    private JsonObject item;
    private List<Triple> triples;
    private NodeMap nodeMap;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean uriValidation;

    private ObjectToRdf(JsonObject item, List<Triple> triples, NodeMap nodeMap, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory, JsonLdOptions options) {
        this.item = item;
        this.triples = triples;
        this.nodeMap = nodeMap;
        this.rdfValueFactory = rdfValueFactory;
        this.rdfDirection = null;
        this.uriValidation = true;
        this.options = options;
    }

    public static <Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> ObjectToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> with(JsonObject item, List<Triple> triples, NodeMap nodeMap, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory, JsonLdOptions options) {
        return new ObjectToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value>(item, triples, nodeMap, rdfValueFactory, options);
    }

    public ObjectToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public Value build() throws JsonLdError {
        boolean absoluteUri;
        String datatype;
        if (NodeObject.isNodeObject((JsonValue)this.item)) {
            JsonValue id = (JsonValue)this.item.get((Object)"@id");
            if (JsonUtils.isNotString(id) || JsonUtils.isNull(id)) {
                return null;
            }
            String idString = ((JsonString)id).getString();
            if (BlankNode.isWellFormed(idString)) {
                return (Value)this.rdfValueFactory.createBlankNode(idString);
            }
            if (UriUtils.isAbsoluteUri(idString, this.uriValidation)) {
                return (Value)this.rdfValueFactory.createIRI(idString);
            }
            return null;
        }
        if (ListObject.isListObject((JsonValue)this.item)) {
            return ListToRdf.with(((JsonValue)this.item.get((Object)"@list")).asJsonArray(), this.triples, this.nodeMap, this.rdfValueFactory, this.options).rdfDirection(this.rdfDirection).uriValidation(this.uriValidation).build();
        }
        if (!ValueObject.isValueObject((JsonValue)this.item)) {
            return null;
        }
        JsonValue value = (JsonValue)this.item.get((Object)"@value");
        String string = datatype = this.item.containsKey((Object)"@type") && JsonUtils.isString((JsonValue)this.item.get((Object)"@type")) ? this.item.getString("@type") : null;
        if (datatype != null && !"@json".equals(datatype) && !(absoluteUri = UriUtils.isAbsoluteUri(datatype, this.uriValidation))) {
            LOGGER.log(Level.WARNING, "Datatype [{0}] is not an absolute IRI nor @json and value is skipped.", datatype);
            if (this.options.isExceptionOnWarning()) {
                throw new JsonLdError(JsonLdErrorCode.UNSPECIFIED, "Datatype '" + datatype + "' is not an absolute IRI nor @json.");
            }
            return null;
        }
        if (this.item.containsKey((Object)"@language") && (JsonUtils.isNotString((JsonValue)this.item.get((Object)"@language")) || !LanguageTag.isWellFormed(this.item.getString("@language")))) {
            LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed string and value is skipped.", this.item.get((Object)"@language"));
            if (this.options.isExceptionOnWarning()) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_STRING, "Language tag '" + String.valueOf(this.item.get((Object)"@language")) + "' is not well formed.");
            }
            return null;
        }
        String valueString = null;
        if ("@json".equals(datatype)) {
            valueString = JsonCanonicalizer.canonicalize(value);
            datatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON";
        } else if (JsonUtils.isTrue(value)) {
            valueString = "true";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (JsonUtils.isFalse(value)) {
            valueString = "false";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (JsonUtils.isNumber(value)) {
            JsonNumber number = (JsonNumber)value;
            if (!number.isIntegral() && number.doubleValue() % -1.0 != 0.0 || "http://www.w3.org/2001/XMLSchema#double".equals(datatype) || "http://www.w3.org/2001/XMLSchema#float".equals(datatype) || number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0) {
                valueString = ObjectToRdf.toXsdDouble(number.bigDecimalValue());
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#double";
                }
            } else {
                valueString = number.bigIntegerValue().toString();
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#integer";
                }
            }
        } else if (datatype == null) {
            String string2 = datatype = this.item.containsKey((Object)"@language") ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : "http://www.w3.org/2001/XMLSchema#string";
        }
        if (valueString == null) {
            if (JsonUtils.isNotString(value)) {
                return null;
            }
            valueString = ((JsonString)value).getString();
        }
        Value rdfLiteral = null;
        if (this.item.containsKey((Object)"@direction") && this.rdfDirection != null) {
            String language;
            String string3 = language = this.item.containsKey((Object)"@language") ? this.item.getString("@language").toLowerCase() : "";
            if (JsonLdOptions.RdfDirection.I18N_DATATYPE == this.rdfDirection) {
                datatype = "https://www.w3.org/ns/i18n#".concat(language).concat("_").concat(this.item.getString("@direction"));
                rdfLiteral = (Value)this.rdfValueFactory.createTypedLiteral(valueString, datatype);
            } else if (JsonLdOptions.RdfDirection.COMPOUND_LITERAL == this.rdfDirection) {
                String blankNodeId = this.nodeMap.createIdentifier();
                Bnode subject = this.rdfValueFactory.createBlankNode(blankNodeId);
                this.triples.add(this.rdfValueFactory.createTriple(subject, this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#value"), this.rdfValueFactory.createString(valueString)));
                if (this.item.containsKey((Object)"@language") && JsonUtils.isString((JsonValue)this.item.get((Object)"@language"))) {
                    this.triples.add(this.rdfValueFactory.createTriple(subject, this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#language"), this.rdfValueFactory.createString(this.item.getString("@language").toLowerCase())));
                }
                this.triples.add(this.rdfValueFactory.createTriple(subject, this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction"), this.rdfValueFactory.createString(this.item.getString("@direction"))));
                return (Value)this.rdfValueFactory.createBlankNode(blankNodeId);
            }
        } else {
            rdfLiteral = this.item.containsKey((Object)"@language") && JsonUtils.isString((JsonValue)this.item.get((Object)"@language")) ? (Value)this.rdfValueFactory.createLangString(valueString, this.item.getString("@language")) : (Value)this.rdfValueFactory.createTypedLiteral(valueString, datatype);
        }
        return rdfLiteral;
    }

    private static String toXsdDouble(BigDecimal bigDecimal) {
        return xsdNumberFormat.format(bigDecimal);
    }

    public ObjectToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> uriValidation(boolean uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    static {
        xsdNumberFormat.setMinimumFractionDigits(1);
    }
}

