/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;

public abstract class Validator
extends ASTVisitor {
    private boolean isvisible = true;
    private final Stack<Item> fStack = new Stack();
    protected ICompilationUnit fCompilationUnit = null;
    private ArrayList<IApiProblem> fProblems = null;

    public boolean visit(AnnotationTypeDeclaration node) {
        this.isvisible &= !Flags.isPrivate((int)node.getModifiers());
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.isvisible));
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.fStack.pop();
        if (!this.fStack.isEmpty()) {
            Item item = this.fStack.peek();
            this.isvisible = item.visible;
        }
    }

    public boolean visit(TypeDeclaration node) {
        int flags = node.getModifiers();
        this.isvisible = Flags.isPrivate((int)flags) ? (this.isvisible &= false) : (node.isMemberTypeDeclaration() ? (this.isvisible &= Flags.isPublic((int)flags) && Flags.isStatic((int)flags) || Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || node.isInterface()) : (this.isvisible &= !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags) || node.isInterface()));
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.isvisible));
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.fStack.pop();
        if (!this.fStack.isEmpty()) {
            Item item = this.fStack.peek();
            this.isvisible = item.visible;
        }
    }

    public boolean visit(EnumDeclaration node) {
        int flags = node.getModifiers();
        this.isvisible = node.isMemberTypeDeclaration() ? (this.isvisible &= Flags.isPublic((int)flags)) : (this.isvisible &= !Flags.isPrivate((int)flags) && !Flags.isPackageDefault((int)flags));
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.isvisible));
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.fStack.pop();
        if (!this.fStack.isEmpty()) {
            Item item = this.fStack.peek();
            this.isvisible = item.visible;
        }
    }

    public boolean visit(RecordDeclaration node) {
        int flags = node.getModifiers();
        this.isvisible = node.isMemberTypeDeclaration() ? (this.isvisible &= Flags.isPublic((int)flags)) : (this.isvisible &= !Flags.isPackageDefault((int)flags));
        this.fStack.push(new Item(this.getTypeName((ASTNode)node), node.getModifiers(), this.isvisible));
        return true;
    }

    public void endVisit(RecordDeclaration node) {
        this.fStack.pop();
        if (!this.fStack.isEmpty()) {
            Item item = this.fStack.peek();
            this.isvisible = item.visible;
        }
    }

    public void endVisit(CompilationUnit node) {
        this.fStack.clear();
    }

    protected Item getItem() {
        return this.fStack.peek();
    }

    protected String getTypeName(ASTNode node) {
        return this.getTypeName(node, new StringBuilder());
    }

    protected String getTypeName(ASTNode node, StringBuilder buffer) {
        if (node.getNodeType() == 15) {
            CompilationUnit unit = (CompilationUnit)node;
            PackageDeclaration packageDeclaration = unit.getPackage();
            if (packageDeclaration != null) {
                buffer.insert(0, '.');
                buffer.insert(0, packageDeclaration.getName().getFullyQualifiedName());
            }
            return buffer.toString();
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
            if (typeDeclaration.isPackageMemberTypeDeclaration()) {
                buffer.insert(0, typeDeclaration.getName().getIdentifier());
            } else {
                buffer.insert(0, typeDeclaration.getName().getFullyQualifiedName());
                buffer.insert(0, '$');
            }
        }
        return this.getTypeName(node.getParent(), buffer);
    }

    protected int getParentKind(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).isInterface() ? 2 : 1;
        }
        if (node instanceof AnnotationTypeDeclaration) {
            return 128;
        }
        if (node instanceof EnumDeclaration) {
            return 64;
        }
        return this.getParentKind(node.getParent());
    }

    protected int getParentModifiers(ASTNode node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
            return type.getModifiers();
        }
        return this.getParentModifiers(node.getParent());
    }

    protected void addProblem(IApiProblem problem) {
        if (this.fProblems == null) {
            this.fProblems = new ArrayList();
        }
        this.fProblems.add(problem);
    }

    public IApiProblem[] getProblems() {
        if (this.fProblems == null) {
            return new IApiProblem[0];
        }
        return this.fProblems.toArray(new IApiProblem[this.fProblems.size()]);
    }

    static class Item {
        String typename;
        int flags;
        boolean visible = false;

        Item(String name, int flags, boolean vis) {
            this.typename = name;
            this.flags = flags;
            this.visible = vis;
        }
    }
}

