/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.IVerificationMaker;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.scenario.Verification;

class ResolvedVerificationType
implements VerificationType {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_ECLASS = "eclass";
    private static final String ATTR_PACKAGE = "epackage-uri";
    private static final String ATTR_CAN_CREATE = "canCreate";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_PHASES = "phases";
    private static final String ATTR_WIDGET = "widget";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PROMPT = "prompt";
    private final String id;
    private final String name;
    private final String description;
    private final EClass eClass;
    private final String contributorId;
    private boolean canCreate;
    private final int priority;
    private final String[] phases;
    private final String[] widgets;
    private final String prompt;

    public ResolvedVerificationType(IConfigurationElement element) throws CoreException {
        int parsed;
        this.id = this.getVal(element, ATTR_ID);
        this.name = this.getVal(element, ATTR_NAME);
        this.description = this.getVal(element, ATTR_DESCRIPTION);
        this.contributorId = element.getContributor().getName();
        this.canCreate = Boolean.TRUE.toString().equals(this.getVal(element, ATTR_CAN_CREATE));
        this.phases = ResolvedVerificationType.parsePhases(this.getVal(element, ATTR_PHASES));
        this.widgets = this.readWidgets(element);
        this.prompt = this.getVal(element, ATTR_PROMPT, null);
        try {
            parsed = Integer.parseInt(this.getVal(element, ATTR_PRIORITY));
        }
        catch (NumberFormatException e) {
            parsed = 10;
        }
        this.priority = parsed;
        String packageUri = this.getVal(element, ATTR_PACKAGE);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        if (ePackage == null) {
            throw new IllegalArgumentException("Invalid package uri for '" + this.id + "' verification type: " + packageUri);
        }
        String className = this.getVal(element, ATTR_ECLASS);
        EClassifier classifier = ePackage.getEClassifier(className);
        if (!(classifier instanceof EClass)) {
            throw new IllegalArgumentException("Invalid class name for '" + this.id + "' verification type: " + className);
        }
        this.eClass = (EClass)classifier;
    }

    private String[] readWidgets(IConfigurationElement element) {
        ArrayList<String> result = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ATTR_WIDGET);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement w = iConfigurationElementArray[n2];
            result.add(this.getVal(w, ATTR_CLASS));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] parsePhases(String text) {
        String[] result = text.split("[\\s,]");
        HashSet<String> members = new HashSet<String>();
        if (result.length == 0) {
            throw new IllegalArgumentException("No phases specified for verification.");
        }
        String[] stringArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!(p.equals("start") || p.equals("run") || p.equals("finish"))) {
                throw new IllegalArgumentException("Invalid phase name '" + p + "'.");
            }
            if (members.contains(p)) {
                throw new IllegalArgumentException("Duplicate phase detected '" + p + "'.");
            }
            members.add(p);
            ++n2;
        }
        return result;
    }

    @Override
    public String[] getPhases() {
        return this.phases;
    }

    @Override
    public boolean supportsPhase(String name) {
        return Arrays.asList(this.phases).contains(name);
    }

    public String getContributorId() {
        return this.contributorId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EClass getEClass() {
        return this.eClass;
    }

    @Override
    public boolean canCreate() {
        return this.canCreate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String[] getWidgets() {
        return this.widgets;
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public boolean supportsWidget(String class_) {
        return Arrays.asList(this.getWidgets()).contains(class_);
    }

    @Override
    public Verification create(Resource resource, String name) {
        return this.getMaker().create(resource, this, name);
    }

    @Override
    public IStatus validate(Verification verification) {
        return this.getMaker().validate(verification);
    }

    @Override
    public IVerificationMaker getMaker() {
        return VerificationTypeManager.getInstance().getMaker(this.getId());
    }

    private String getVal(IConfigurationElement element, String attr) {
        String val = element.getAttribute(attr);
        if (val == null || val.length() == 0) {
            throw new IllegalArgumentException("Verification attribute '" + attr + "' can't be empty");
        }
        return val;
    }

    private String getVal(IConfigurationElement element, String attr, String defaultValue) {
        String val = element.getAttribute(attr);
        if (val == null || val.length() == 0) {
            val = defaultValue;
        }
        return val;
    }

    @Override
    public boolean canMake() {
        return this.getMaker().canMake();
    }
}

