/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;

public class ModelUtils {
    public static int countElements(Object eGet, EObject element) {
        int count;
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            count = 0;
                            if (!(eGet instanceof EObject) || !EcoreUtil.equals((EObject)((EObject)eGet), (EObject)element)) break block3;
                            ++count;
                            break block4;
                        }
                        if (!(eGet instanceof EObject)) break block5;
                        count += ModelUtils.countElements((EObject)eGet, element);
                        break block4;
                    }
                    if (!(eGet instanceof List)) break block6;
                    List l = (List)eGet;
                    for (Object object : l) {
                        count += ModelUtils.countElements(object, element);
                    }
                    break block4;
                }
                if (!(eGet instanceof Map)) break block7;
                Map l = (Map)eGet;
                for (Object object : l.values()) {
                    count += ModelUtils.countElements(object, element);
                }
                break block4;
            }
            if (!(eGet instanceof Set)) break block4;
            Set l = (Set)eGet;
            for (Object object : l) {
                count += ModelUtils.countElements(object, element);
            }
        }
        return count;
    }

    public static void extractElements(Object eGet, Set<Element> elements) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if (!(eGet instanceof Element)) break block3;
                            elements.add((Element)eGet);
                            break block4;
                        }
                        if (!(eGet instanceof EObject)) break block5;
                        ModelUtils.extractElements((EObject)eGet, elements);
                        break block4;
                    }
                    if (!(eGet instanceof List)) break block6;
                    List l = (List)eGet;
                    for (Object object : l) {
                        ModelUtils.extractElements(object, elements);
                    }
                    break block4;
                }
                if (!(eGet instanceof Map)) break block7;
                Map l = (Map)eGet;
                for (Object object : l.values()) {
                    ModelUtils.extractElements(object, elements);
                }
                break block4;
            }
            if (!(eGet instanceof Set)) break block4;
            Set l = (Set)eGet;
            for (Object object : l) {
                ModelUtils.extractElements(object, elements);
            }
        }
    }

    public static int countElements(EObject obj, EObject element) {
        int count = 0;
        EClass eClass = obj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : features) {
            Object eGet = obj.eGet(eStructuralFeature);
            if (eGet == null) continue;
            count += ModelUtils.countElements(eGet, element);
        }
        return count;
    }

    public static Set<Element> extractElements(EObject response) {
        HashSet<Element> elements = new HashSet<Element>();
        ModelUtils.extractElements(response, elements);
        return elements;
    }

    public static void extractElements(EObject response, Set<Element> elements) {
        EClass eClass = response.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : features) {
            Object eGet = response.eGet(eStructuralFeature);
            if (eGet == null) continue;
            ModelUtils.extractElements(eGet, elements);
        }
    }

    public static void updateElementsAccordingTo(Object eGet, Map<String, Element> map, Set<EObject> updated) {
        try {
            if (eGet instanceof EObject) {
                ModelUtils.updateElementsAccordingTo((EObject)eGet, map, updated);
            } else if (eGet instanceof List) {
                List l = (List)eGet;
                ArrayList<Element> newL = new ArrayList<Element>();
                ArrayList lcopy = new ArrayList(l);
                for (Object object : lcopy) {
                    if (object instanceof Element) {
                        newL.add(ModelUtils.getRealElement(map, object));
                        continue;
                    }
                    newL.add((Element)object);
                    ModelUtils.updateElementsAccordingTo(object, map, updated);
                }
                try {
                    l.clear();
                    l.addAll(newL);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            } else if (eGet instanceof Map) {
                Map l = (Map)eGet;
                HashMap newL = new HashMap();
                for (Map.Entry entry : l.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Element) {
                        value = ModelUtils.getRealElement(map, value);
                    } else {
                        ModelUtils.updateElementsAccordingTo(value, map, updated);
                    }
                    newL.put(key, value);
                }
                l.clear();
                l.putAll(newL);
            } else if (eGet instanceof Set) {
                Set l = (Set)eGet;
                HashSet result = new HashSet();
                for (Object object : l) {
                    Object o = object;
                    if (o instanceof Element) {
                        o = ModelUtils.getRealElement(map, o);
                    } else {
                        ModelUtils.updateElementsAccordingTo(o, map, updated);
                    }
                    result.add(o);
                }
                l.clear();
                l.addAll(result);
            }
        }
        catch (Exception e) {
            TeslaCore.log(e);
        }
    }

    public static void updateElementsAccordingTo(EObject workCmd, Map<String, Element> map, Set<EObject> updated) {
        if (updated.contains(workCmd)) {
            return;
        }
        updated.add(workCmd);
        EClass eClass = workCmd.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : features) {
            Object eGet = workCmd.eGet(eStructuralFeature);
            if (eGet instanceof Element) {
                workCmd.eSet(eStructuralFeature, (Object)ModelUtils.getRealElement(map, eGet));
                continue;
            }
            if (eGet == null) continue;
            ModelUtils.updateElementsAccordingTo(eGet, map, updated);
        }
    }

    private static Element getRealElement(Map<String, Element> map, Object eGet) {
        String key = ModelUtils.makeKey((Element)eGet);
        Element e = map.get(key);
        if (e != null) {
            return (Element)EcoreUtil.copy((EObject)e);
        }
        throw new RuntimeException("Failed to map elements.");
    }

    public static String makeKey(Element element) {
        return element.getKind() + ":" + element.getId();
    }
}

