/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.core.toc.text.TocTopic;
import org.eclipse.pde.internal.ua.ui.editor.toc.actions.TocActionMessages;

public class TocRemoveObjectAction
extends Action {
    private TocObject[] fTocObjects;
    private TocObject fObjectToSelect;

    public TocRemoveObjectAction() {
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setText(TocActionMessages.TocRemoveObjectAction_remove);
        this.fTocObjects = null;
        this.fObjectToSelect = null;
    }

    public void setToRemove(TocObject[] tocObjects) {
        this.fTocObjects = tocObjects;
    }

    public void setToRemove(TocObject tocObject) {
        this.fTocObjects = new TocObject[]{tocObject};
    }

    public void run() {
        if (this.fTocObjects == null) {
            return;
        }
        int i = 0;
        while (i < this.fTocObjects.length) {
            TocObject parent;
            if (this.fTocObjects[i] != null && this.fTocObjects[i].canBeRemoved() && (parent = this.fTocObjects[i].getParent()) != null && parent.canBeParent()) {
                this.determineNextSelection(parent, i);
                ((TocTopic)parent).removeChild(this.fTocObjects[i]);
            }
            ++i;
        }
    }

    private void determineNextSelection(TocObject parent, int index) {
        this.fObjectToSelect = parent.getNextSibling(this.fTocObjects[index]);
        if (this.fObjectToSelect == null) {
            this.fObjectToSelect = parent.getPreviousSibling(this.fTocObjects[index]);
            if (this.fObjectToSelect == null) {
                this.fObjectToSelect = parent;
            }
        }
    }

    public TocObject getNextSelection() {
        return this.fObjectToSelect;
    }
}

