/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.debug;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rcptt.ecl.debug.core.EclDebug;
import org.eclipse.rcptt.ui.editors.context.ContextEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.ui.IWorkbenchPart;

public class EclLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    private final IResource resource;

    public EclLineBreakpointAdapter(IResource resource) {
        this.resource = resource;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof ContextEditor) {
            part = ((ContextEditor)part).getEditor();
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.rcptt.ecl.debug.core");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (this.resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                breakpoint.delete();
                return;
            }
            ++i;
        }
        LineBreakpoint breakpoint = EclDebug.createBreakpoint((IResource)this.resource, (int)(lineNumber + 1));
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ContextEditor) {
            part = ((ContextEditor)part).getEditor();
        }
        return part instanceof EclEditor;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

