/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class HeapWalkingManager {
    private static HeapWalkingManager fgSingleton;

    protected HeapWalkingManager() {
    }

    public static boolean supportsHeapWalking(Object object) {
        if (object instanceof IDebugElement) {
            Object adapter;
            IDebugTarget target = ((IDebugElement)object).getDebugTarget();
            if (target instanceof IJavaDebugTarget) {
                return ((IJavaDebugTarget)target).supportsInstanceRetrieval();
            }
            if (target != null && (adapter = target.getAdapter(IJavaDebugTarget.class)) instanceof IJavaDebugTarget) {
                return ((IJavaDebugTarget)adapter).supportsInstanceRetrieval();
            }
        }
        return false;
    }

    public static HeapWalkingManager getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new HeapWalkingManager();
        }
        return fgSingleton;
    }

    public boolean isShowReferenceInVarView() {
        return Platform.getPreferencesService().getBoolean(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugPlugin.PREF_SHOW_REFERENCES_IN_VAR_VIEW, false, null);
    }

    public int getAllReferencesMaxCount() {
        return Platform.getPreferencesService().getInt(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugPlugin.PREF_ALL_REFERENCES_MAX_COUNT, 100, null);
    }

    public int getAllInstancesMaxCount() {
        return Platform.getPreferencesService().getInt(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugPlugin.PREF_ALL_INSTANCES_MAX_COUNT, 100, null);
    }

    public void setShowReferenceInVarView(boolean value) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.putBoolean(JDIDebugPlugin.PREF_SHOW_REFERENCES_IN_VAR_VIEW, value);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugPlugin.log(e);
            }
        }
    }

    public void setAllReferencesMaxCount(int max) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.putInt(JDIDebugPlugin.PREF_ALL_REFERENCES_MAX_COUNT, max);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugPlugin.log(e);
            }
        }
    }

    public void setAllInstancesMaxCount(int max) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.putInt(JDIDebugPlugin.PREF_ALL_INSTANCES_MAX_COUNT, max);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugPlugin.log(e);
            }
        }
    }

    public void resetToDefaultSettings() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.putBoolean(JDIDebugPlugin.PREF_SHOW_REFERENCES_IN_VAR_VIEW, false);
            node.putInt(JDIDebugPlugin.PREF_ALL_REFERENCES_MAX_COUNT, 100);
            node.putInt(JDIDebugPlugin.PREF_ALL_INSTANCES_MAX_COUNT, 100);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugPlugin.log(e);
            }
        }
    }
}

