/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.text;

import java.util.BitSet;
import java.util.Set;
import org.commonmark.text.CharMatcher;

public class AsciiMatcher
implements CharMatcher {
    private final BitSet set;

    private AsciiMatcher(Builder builder) {
        this.set = builder.set;
    }

    @Override
    public boolean matches(char c) {
        return this.set.get(c);
    }

    public Builder newBuilder() {
        return new Builder((BitSet)this.set.clone());
    }

    public static Builder builder() {
        return new Builder(new BitSet());
    }

    public static Builder builder(AsciiMatcher matcher) {
        return new Builder((BitSet)matcher.set.clone());
    }

    public static class Builder {
        private final BitSet set;

        private Builder(BitSet set) {
            this.set = set;
        }

        public Builder c(char c) {
            if (c > '\u007f') {
                throw new IllegalArgumentException("Can only match ASCII characters");
            }
            this.set.set(c);
            return this;
        }

        public Builder anyOf(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.c(s.charAt(i));
            }
            return this;
        }

        public Builder anyOf(Set<Character> characters) {
            for (Character c : characters) {
                this.c(c.charValue());
            }
            return this;
        }

        public Builder range(char from, char toInclusive) {
            for (char c = from; c <= toInclusive; c = (char)(c + '\u0001')) {
                this.c(c);
            }
            return this;
        }

        public AsciiMatcher build() {
            return new AsciiMatcher(this);
        }
    }
}

