/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.bundle.BundleObject;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.osgi.framework.BundleException;

public class CompositeManifestHeader
extends ManifestHeader {
    private static final PDEManifestElement[] NO_ELEMENTS = new PDEManifestElement[0];
    private static final long serialVersionUID = 1L;
    private final boolean fSort;
    private final Comparator<String> fElementComparator;
    protected List<PDEManifestElement> fManifestElements;
    protected Map<String, PDEManifestElement> fElementMap;

    public CompositeManifestHeader(String name, String value, IBundle bundle, String lineDelimiter) {
        this(name, value, bundle, lineDelimiter, null);
    }

    public CompositeManifestHeader(String name, String value, IBundle bundle, String lineDelimiter, Comparator<String> elementComparator) {
        this.fName = name;
        this.fBundle = bundle;
        this.fLineDelimiter = lineDelimiter;
        this.setModel(this.fBundle.getModel());
        this.fSort = elementComparator != null;
        this.fElementComparator = elementComparator;
        this.fValue = value;
        this.processValue(value);
    }

    @Override
    protected void processValue(String value) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)this.fName, (String)value);
            if (elements != null) {
                ManifestElement[] manifestElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement element = manifestElementArray[n2];
                    this.addManifestElement(this.createElement(element), false);
                    ++n2;
                }
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    protected PDEManifestElement createElement(ManifestElement element) {
        return new PDEManifestElement((ManifestHeader)this, element);
    }

    @Override
    public void update() {
        this.update(false);
    }

    @Override
    public void update(boolean notify) {
        PDEManifestElement[] elements;
        StringBuilder sb = new StringBuilder();
        PDEManifestElement[] pDEManifestElementArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            PDEManifestElement element = pDEManifestElementArray[n2];
            if (sb.length() > 0) {
                sb.append(",");
                sb.append(this.fLineDelimiter);
                sb.append(" ");
            }
            sb.append(element.write());
            ++n2;
        }
        String old = this.fValue;
        this.fValue = sb.toString();
        if (notify) {
            this.firePropertyChanged(this, this.fName, old, this.fValue);
        }
    }

    protected void addManifestElement(String value) {
        this.addManifestElement(new PDEManifestElement((ManifestHeader)this, value));
    }

    protected void addManifestElement(String value, int index) {
        PDEManifestElement element = new PDEManifestElement((ManifestHeader)this, value);
        this.addManifestElement(element, index, true);
    }

    protected void addManifestElement(PDEManifestElement element) {
        this.addManifestElement(element, true);
    }

    protected void addManifestElements(List<? extends PDEManifestElement> elements) {
        for (PDEManifestElement pDEManifestElement : elements) {
            this.addManifestElement(pDEManifestElement, false);
        }
        this.update(false);
        this.fireStructureChanged((BundleObject[])elements.toArray(PDEManifestElement[]::new), 1);
    }

    protected void addManifestElement(PDEManifestElement element, boolean update) {
        element.setModel(this.getModel());
        element.setHeader(this);
        if (this.fSort) {
            if (this.fElementMap == null) {
                this.fElementMap = new TreeMap<String, PDEManifestElement>(this.fElementComparator);
            }
            this.fElementMap.put(element.getValue(), element);
        } else {
            if (this.fManifestElements == null) {
                this.fManifestElements = new ArrayList<PDEManifestElement>(1);
            }
            this.fManifestElements.add(element);
        }
        if (update) {
            this.update(false);
            this.fireStructureChanged(element, 1);
        }
    }

    protected Object removeManifestElement(PDEManifestElement element) {
        return this.removeManifestElement(element.getValue());
    }

    protected Object removeManifestElement(String name) {
        PDEManifestElement object = null;
        if (this.fSort) {
            if (this.fElementMap != null) {
                object = this.fElementMap.remove(name);
            }
        } else if (this.fManifestElements != null) {
            int i = 0;
            while (i < this.fManifestElements.size()) {
                PDEManifestElement element = this.fManifestElements.get(i);
                if (name.equals(element.getValue())) {
                    object = this.fManifestElements.remove(i);
                }
                ++i;
            }
        }
        this.update(false);
        if (object instanceof BundleObject) {
            this.fireStructureChanged(object, 2);
        }
        return object;
    }

    public PDEManifestElement[] getElements() {
        if (this.fSort && this.fElementMap != null) {
            return this.fElementMap.values().toArray(new PDEManifestElement[this.fElementMap.size()]);
        }
        if (this.fManifestElements != null) {
            return this.fManifestElements.toArray(new PDEManifestElement[this.fManifestElements.size()]);
        }
        return NO_ELEMENTS;
    }

    public boolean isEmpty() {
        if (this.fSort) {
            return this.fElementMap == null || this.fElementMap.isEmpty();
        }
        return this.fManifestElements == null || this.fManifestElements.isEmpty();
    }

    public boolean hasElement(String name) {
        if (this.fSort && this.fElementMap != null) {
            return this.fElementMap.containsKey(name);
        }
        if (this.fManifestElements != null) {
            for (PDEManifestElement element : this.fManifestElements) {
                if (!name.equals(element.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getElementNames() {
        PDEManifestElement[] elements = this.getElements();
        return Arrays.stream(elements).map(PDEManifestElement::getValue).toList();
    }

    public void swap(int index1, int index2) {
        if (this.fSort || this.fManifestElements == null) {
            return;
        }
        int size = this.fManifestElements.size();
        if (index1 >= 0 && index2 >= 0 && size > Math.max(index1, index2)) {
            Collections.swap(this.fManifestElements, index1, index2);
            this.update(true);
        }
    }

    protected PDEManifestElement getElementAt(int index) {
        if (this.fManifestElements != null && this.fManifestElements.size() > index) {
            return this.fManifestElements.get(index);
        }
        return null;
    }

    public PDEManifestElement getPreviousElement(PDEManifestElement targetElement) {
        if (this.fSort) {
            return null;
        }
        if (this.fManifestElements == null) {
            return null;
        }
        if (this.fManifestElements.size() <= 1) {
            return null;
        }
        int targetIndex = this.fManifestElements.indexOf(targetElement);
        if (targetIndex < 0) {
            return null;
        }
        if (targetIndex == 0) {
            return null;
        }
        return this.fManifestElements.get(targetIndex - 1);
    }

    public PDEManifestElement getNextElement(PDEManifestElement targetElement) {
        if (this.fSort) {
            return null;
        }
        if (this.fManifestElements == null) {
            return null;
        }
        if (this.fManifestElements.size() <= 1) {
            return null;
        }
        int targetIndex = this.fManifestElements.indexOf(targetElement);
        int lastIndex = this.fManifestElements.size() - 1;
        if (targetIndex < 0) {
            return null;
        }
        if (targetIndex >= lastIndex) {
            return null;
        }
        return this.fManifestElements.get(targetIndex + 1);
    }

    protected void addManifestElement(PDEManifestElement element, int index, boolean update) {
        int elementCount = 0;
        if (this.fManifestElements != null) {
            elementCount = this.fManifestElements.size();
        }
        if (this.fSort) {
            return;
        }
        if (index < 0) {
            return;
        }
        if (index > elementCount) {
            return;
        }
        element.setModel(this.getModel());
        element.setHeader(this);
        if (this.fManifestElements == null) {
            this.fManifestElements = new ArrayList<PDEManifestElement>(1);
            this.fManifestElements.add(element);
        } else {
            this.fManifestElements.add(index, element);
        }
        if (update) {
            this.update(false);
            this.fireStructureChanged(element, 1);
        }
    }

    public int indexOf(PDEManifestElement targetElement) {
        if (this.fSort) {
            return -1;
        }
        if (this.fManifestElements == null) {
            return -1;
        }
        return this.fManifestElements.indexOf(targetElement);
    }
}

