/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.text;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.internal.renderer.NodeRendererMap;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.Renderer;
import org.commonmark.renderer.text.CoreTextContentNodeRenderer;
import org.commonmark.renderer.text.LineBreakRendering;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentNodeRendererFactory;
import org.commonmark.renderer.text.TextContentWriter;

public class TextContentRenderer
implements Renderer {
    private final LineBreakRendering lineBreakRendering;
    private final List<TextContentNodeRendererFactory> nodeRendererFactories;

    private TextContentRenderer(Builder builder) {
        this.lineBreakRendering = builder.lineBreakRendering;
        this.nodeRendererFactories = new ArrayList<TextContentNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new TextContentNodeRendererFactory(){

            @Override
            public NodeRenderer create(TextContentNodeRendererContext context) {
                return new CoreTextContentNodeRenderer(context);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node, Appendable output) {
        RendererContext context = new RendererContext(new TextContentWriter(output, this.lineBreakRendering));
        context.render(node);
    }

    @Override
    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    private class RendererContext
    implements TextContentNodeRendererContext {
        private final TextContentWriter textContentWriter;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();

        private RendererContext(TextContentWriter textContentWriter) {
            this.textContentWriter = textContentWriter;
            for (TextContentNodeRendererFactory factory : TextContentRenderer.this.nodeRendererFactories) {
                NodeRenderer renderer = factory.create(this);
                this.nodeRendererMap.add(renderer);
            }
        }

        @Override
        public LineBreakRendering lineBreakRendering() {
            return TextContentRenderer.this.lineBreakRendering;
        }

        @Override
        public boolean stripNewlines() {
            return TextContentRenderer.this.lineBreakRendering == LineBreakRendering.STRIP;
        }

        @Override
        public TextContentWriter getWriter() {
            return this.textContentWriter;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }
    }

    public static interface TextContentRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private List<TextContentNodeRendererFactory> nodeRendererFactories = new ArrayList<TextContentNodeRendererFactory>();
        private LineBreakRendering lineBreakRendering = LineBreakRendering.COMPACT;

        public TextContentRenderer build() {
            return new TextContentRenderer(this);
        }

        public Builder lineBreakRendering(LineBreakRendering lineBreakRendering) {
            this.lineBreakRendering = lineBreakRendering;
            return this;
        }

        @Deprecated
        public Builder stripNewlines(boolean stripNewlines) {
            this.lineBreakRendering = stripNewlines ? LineBreakRendering.STRIP : LineBreakRendering.COMPACT;
            return this;
        }

        public Builder nodeRendererFactory(TextContentNodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof TextContentRendererExtension)) continue;
                TextContentRendererExtension textContentRendererExtension = (TextContentRendererExtension)extension;
                textContentRendererExtension.extend(this);
            }
            return this;
        }
    }
}

