/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.text.edits.TextEditGroup;

public class ModifierRewrite {
    public static final int VISIBILITY_MODIFIERS = 7;
    private ListRewrite fModifierRewrite;
    private AST fAst;

    public static ModifierRewrite create(ASTRewrite rewrite, ASTNode declNode) {
        return new ModifierRewrite(rewrite, declNode);
    }

    private ModifierRewrite(ASTRewrite rewrite, ASTNode declNode) {
        this.fModifierRewrite = this.evaluateListRewrite(rewrite, declNode);
        this.fAst = declNode.getAST();
    }

    private ListRewrite evaluateListRewrite(ASTRewrite rewrite, ASTNode declNode) {
        switch (declNode.getNodeType()) {
            case 31: {
                return rewrite.getListRewrite(declNode, MethodDeclaration.MODIFIERS2_PROPERTY);
            }
            case 23: {
                return rewrite.getListRewrite(declNode, FieldDeclaration.MODIFIERS2_PROPERTY);
            }
            case 58: {
                return rewrite.getListRewrite(declNode, VariableDeclarationExpression.MODIFIERS2_PROPERTY);
            }
            case 60: {
                return rewrite.getListRewrite(declNode, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
            }
            case 44: {
                return rewrite.getListRewrite(declNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            }
            case 55: {
                return rewrite.getListRewrite(declNode, TypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 103: {
                return rewrite.getListRewrite(declNode, RecordDeclaration.MODIFIERS2_PROPERTY);
            }
            case 71: {
                return rewrite.getListRewrite(declNode, EnumDeclaration.MODIFIERS2_PROPERTY);
            }
            case 81: {
                return rewrite.getListRewrite(declNode, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 72: {
                return rewrite.getListRewrite(declNode, EnumConstantDeclaration.MODIFIERS2_PROPERTY);
            }
            case 82: {
                return rewrite.getListRewrite(declNode, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY);
            }
        }
        throw new IllegalArgumentException("node has no modifiers: " + declNode.getClass().getName());
    }

    public ListRewrite getModifierRewrite() {
        return this.fModifierRewrite;
    }

    public LinkedProposalPositionGroupCore.PositionInformation setModifiers(int modifiers, TextEditGroup editGroup) {
        return this.internalSetModifiers(modifiers, -1, editGroup);
    }

    public LinkedProposalPositionGroupCore.PositionInformation setModifiers(int included, int excluded, TextEditGroup editGroup) {
        return this.internalSetModifiers(included, included | excluded, editGroup);
    }

    public LinkedProposalPositionGroupCore.PositionInformation setVisibility(int visibilityFlags, TextEditGroup editGroup) {
        return this.internalSetModifiers(visibilityFlags, 7, editGroup);
    }

    public void copyAllModifiers(ASTNode otherDecl, TextEditGroup editGroup) {
        this.copyAllModifiers(otherDecl, editGroup, false);
    }

    public void copyAllModifiers(ASTNode otherDecl, TextEditGroup editGroup, boolean copyIndividually) {
        ListRewrite modifierList = this.evaluateListRewrite(this.fModifierRewrite.getASTRewrite(), otherDecl);
        List originalList = modifierList.getOriginalList();
        if (originalList.isEmpty()) {
            return;
        }
        if (copyIndividually) {
            for (IExtendedModifier iExtendedModifier : originalList) {
                ASTNode modifier = (ASTNode)iExtendedModifier;
                ASTNode copy = this.fModifierRewrite.getASTRewrite().createCopyTarget(modifier);
                if (copy == null) continue;
                this.fModifierRewrite.insertLast(copy, editGroup);
            }
        } else {
            ASTNode copy = modifierList.createCopyTarget((ASTNode)originalList.get(0), (ASTNode)originalList.get(originalList.size() - 1));
            if (copy != null) {
                this.fModifierRewrite.insertLast(copy, editGroup);
            }
        }
    }

    public void copyAllAnnotations(ASTNode otherDecl, TextEditGroup editGroup) {
        ListRewrite modifierList = this.evaluateListRewrite(this.fModifierRewrite.getASTRewrite(), otherDecl);
        List originalList = modifierList.getOriginalList();
        for (IExtendedModifier modifier : originalList) {
            if (!modifier.isAnnotation()) continue;
            this.fModifierRewrite.insertLast(this.fModifierRewrite.getASTRewrite().createCopyTarget((ASTNode)((Annotation)modifier)), editGroup);
        }
    }

    private LinkedProposalPositionGroupCore.PositionInformation internalSetModifiers(int modifiers, int consideredFlags, TextEditGroup editGroup) {
        int newModifiers = modifiers & consideredFlags;
        ITrackedNodePosition trackedFallback = null;
        ArrayList<ITrackedNodePosition> trackedNodes = new ArrayList<ITrackedNodePosition>();
        List originalList = this.fModifierRewrite.getOriginalList();
        for (IExtendedModifier element : originalList) {
            int flag;
            ASTNode curr = (ASTNode)element;
            if (!(curr instanceof Modifier) || (consideredFlags & (flag = ((Modifier)curr).getKeyword().toFlagValue())) == 0) continue;
            if ((newModifiers & flag) == 0) {
                this.fModifierRewrite.remove(curr, editGroup);
                if (trackedFallback == null) {
                    trackedFallback = this.fModifierRewrite.getASTRewrite().track(curr);
                }
            }
            newModifiers &= ~flag;
        }
        ASTNode lastAnnotation = null;
        List extendedList = this.fModifierRewrite.getRewrittenList();
        for (ASTNode curr : extendedList) {
            if (!curr.isAnnotation()) continue;
            lastAnnotation = curr;
        }
        List<Modifier> newNodes = ASTNodeFactory.newModifiers(this.fAst, newModifiers);
        for (Modifier curr : newNodes) {
            if ((curr.getKeyword().toFlagValue() & 7) != 0) {
                if (lastAnnotation != null) {
                    this.fModifierRewrite.insertAfter((ASTNode)curr, lastAnnotation, editGroup);
                } else {
                    this.fModifierRewrite.insertFirst((ASTNode)curr, editGroup);
                }
            } else {
                this.fModifierRewrite.insertLast((ASTNode)curr, editGroup);
            }
            trackedNodes.add(this.fModifierRewrite.getASTRewrite().track((ASTNode)curr));
        }
        if (trackedNodes.isEmpty()) {
            if (trackedFallback == null) {
                trackedFallback = this.fModifierRewrite.getASTRewrite().track(this.fModifierRewrite.getParent());
            }
            return new LinkedProposalPositionGroupCore.StartPositionInformation(trackedFallback);
        }
        return new LinkedProposalPositionGroupCore.TrackedNodesPosition(trackedNodes);
    }
}

