/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ProjectClasspathPreferenceChangeListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DSLibPluginModelListener
implements IPluginModelListener {
    private static DSLibPluginModelListener INSTANCE;
    private final HashMap<IJavaProject, String> projects = new HashMap();
    private final HashMap<String, Integer> counts = new HashMap();

    private DSLibPluginModelListener() {
        PluginModelManager.getInstance().addPluginModelListener((IPluginModelListener)this);
    }

    private static synchronized DSLibPluginModelListener getInstance(boolean create) {
        if (create && INSTANCE == null) {
            INSTANCE = new DSLibPluginModelListener();
        }
        return INSTANCE;
    }

    private void decrementCount(String modelId) {
        Integer oldCount = this.counts.get(modelId);
        if (oldCount != null) {
            if (oldCount <= 1) {
                this.counts.remove(modelId);
            } else {
                this.counts.put(modelId, oldCount - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProject(IJavaProject project, String modelId) {
        DSLibPluginModelListener instance = DSLibPluginModelListener.getInstance(true);
        HashMap<IJavaProject, String> hashMap = instance.projects;
        synchronized (hashMap) {
            String oldModelId = instance.projects.put(project, modelId);
            Integer count = instance.counts.getOrDefault(modelId, 0);
            instance.counts.put(modelId, count + 1);
            if (oldModelId != null) {
                instance.decrementCount(oldModelId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProject(IJavaProject project) {
        DSLibPluginModelListener instance = DSLibPluginModelListener.getInstance(false);
        if (instance != null) {
            HashMap<IJavaProject, String> hashMap = instance.projects;
            synchronized (hashMap) {
                String oldModelId = instance.projects.remove(project);
                if (oldModelId != null) {
                    instance.decrementCount(oldModelId);
                }
            }
        }
    }

    private boolean containsModel(ModelEntry[] entries, String id) {
        ModelEntry[] modelEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ModelEntry entry = modelEntryArray[n2];
            if ("org.eclipse.pde.ds.lib".equals(entry.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelsChanged(PluginModelDelta delta) {
        HashMap<IJavaProject, String> hashMap = this.projects;
        synchronized (hashMap) {
            HashSet<String> modelIds = new HashSet<String>(2);
            for (String modelId : this.counts.keySet()) {
                if (!((delta.getKind() & 1) != 0 && this.containsModel(delta.getAddedEntries(), modelId) || (delta.getKind() & 4) != 0 && this.containsModel(delta.getChangedEntries(), modelId)) && ((delta.getKind() & 2) == 0 || !this.containsModel(delta.getRemovedEntries(), modelId))) continue;
                modelIds.add(modelId);
            }
            ArrayList<IJavaProject> toUpdate = new ArrayList<IJavaProject>(this.projects.size());
            if (!modelIds.isEmpty()) {
                for (Map.Entry<IJavaProject, String> entry : this.projects.entrySet()) {
                    IJavaProject project = entry.getKey();
                    String modelId = entry.getValue();
                    if (!modelIds.contains(modelId)) continue;
                    toUpdate.add(project);
                }
            }
            if (!toUpdate.isEmpty()) {
                this.requestClasspathUpdate(toUpdate);
            }
        }
    }

    private void requestClasspathUpdate(final Collection<IJavaProject> changedProjects) {
        WorkspaceJob job = new WorkspaceJob(Messages.ProjectClasspathPreferenceChangeListener_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DSAnnotationPreferenceListener_taskName, (int)changedProjects.size());
                for (IJavaProject project : changedProjects) {
                    ProjectClasspathPreferenceChangeListener.updateClasspathContainer(project, (IProgressMonitor)progress.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        ISchedulingRule[] rules = (ISchedulingRule[])changedProjects.stream().map(IJavaProject::getProject).toArray(ISchedulingRule[]::new);
        job.setRule((ISchedulingRule)new MultiRule(rules));
        Display display = Display.getCurrent();
        if (display != null) {
            PlatformUI.getWorkbench().getProgressService().showInDialog(display.getActiveShell(), (Job)job);
        }
        job.schedule();
    }

    public static void dispose() {
        DSLibPluginModelListener instance = DSLibPluginModelListener.getInstance(false);
        if (instance != null) {
            PluginModelManager.getInstance().removePluginModelListener((IPluginModelListener)instance);
        }
    }
}

