/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSRun;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleCSCommandDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleDetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class SimpleCSSubItemDetails
extends CSAbstractDetails {
    private ISimpleCSSubItem fSubItem = null;
    private FormEntry fLabel = null;
    private Button fSkip = null;
    private Section fMainSection = null;
    private final SimpleCSCommandDetails fCommandSection;

    public SimpleCSSubItemDetails(ICSMaster masterTreeSection) {
        super(masterTreeSection, "simplecs-context");
        this.fCommandSection = new SimpleCSCommandDetails(masterTreeSection);
    }

    public void setData(ISimpleCSSubItem object) {
        this.fSubItem = object;
        this.fCommandSection.setData((ISimpleCSRun)object);
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object == null || !(object instanceof ISimpleCSSubItem)) {
            return;
        }
        this.setData((ISimpleCSSubItem)object);
        this.updateFields();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.fCommandSection.initialize(form);
    }

    @Override
    public void createDetails(Composite parent) {
        GridData data = null;
        this.fMainSection = this.getToolkit().createSection(parent, 384);
        this.fMainSection.clientVerticalSpacing = 6;
        this.fMainSection.setText(SimpleDetailsMessages.SimpleCSSubItemDetails_mainSectionText);
        this.fMainSection.setDescription(SimpleDetailsMessages.SimpleCSSubItemDetails_mainSectionDesc);
        this.fMainSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        data = new GridData(768);
        this.fMainSection.setLayoutData((Object)data);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite mainSectionClient = this.getToolkit().createComposite((Composite)this.fMainSection);
        mainSectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        this.fLabel = new FormEntry(mainSectionClient, this.getToolkit(), SimpleDetailsMessages.SimpleCSSubItemDetails_attrBody, 578);
        data = new GridData(768);
        data.heightHint = 50;
        this.fLabel.getText().setLayoutData((Object)data);
        data = new GridData(130);
        this.fLabel.getLabel().setLayoutData((Object)data);
        this.fSkip = this.getToolkit().createButton(mainSectionClient, SimpleDetailsMessages.SimpleCSSubItemDetails_attrSkip, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.fSkip.setLayoutData((Object)data);
        this.getToolkit().paintBordersFor(mainSectionClient);
        this.fMainSection.setClient((Control)mainSectionClient);
        this.markDetailsPart((Control)this.fMainSection);
        this.fCommandSection.createDetails(parent);
    }

    @Override
    public void hookListeners() {
        this.fLabel.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (SimpleCSSubItemDetails.this.fSubItem == null) {
                    return;
                }
                SimpleCSSubItemDetails.this.fSubItem.setLabel(SimpleCSSubItemDetails.this.fLabel.getValue());
            }
        });
        this.fSkip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSSubItemDetails.this.fSubItem == null) {
                    return;
                }
                SimpleCSSubItemDetails.this.fSubItem.setSkip(SimpleCSSubItemDetails.this.fSkip.getSelection());
            }
        });
        this.fCommandSection.hookListeners();
    }

    @Override
    public void updateFields() {
        boolean editable = this.isEditableElement();
        if (this.fSubItem == null) {
            return;
        }
        this.fLabel.setValue(this.fSubItem.getLabel(), true);
        this.fLabel.setEditable(editable);
        this.fSkip.setSelection(this.fSubItem.getSkip());
        this.fSkip.setEnabled(editable);
        this.fCommandSection.updateFields();
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fLabel.commit();
    }
}

