/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.EmptyDebugTarget;
import org.eclipse.m2m.internal.qvt.oml.common.launch.InMemoryLaunchUtils;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ShallowProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;

public class InMemoryQvtLaunchConfigurationDelegate
extends QvtLaunchConfigurationDelegateBase {
    public static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2m.qvt.oml.InMemoryQvtTransformation";
    public static final IStatus statusJobDone = new Status(1, "org.eclipse.m2m.qvt.oml.runtime", 200, "", null);

    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object transObj = InMemoryLaunchUtils.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.m2m.qvt.oml.interpreter.transformationId");
        if (!(transObj instanceof QvtTransformation)) {
            throw new IllegalArgumentException("Invalid transformation " + transObj);
        }
        final QvtTransformation qvtTransformation = (QvtTransformation)transObj;
        Runnable doneAction = (Runnable)InMemoryLaunchUtils.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.m2m.qvt.oml.interpreter.doneAction");
        final StreamsProxy streamsProxy = new StreamsProxy();
        BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

            public void run() throws Exception {
                IStatus status = QvtLaunchConfigurationDelegateBase.validate(qvtTransformation, configuration);
                if (status.getSeverity() > 2) {
                    throw new CoreException(status);
                }
                Context context = QvtLaunchUtil.createContext(configuration);
                context.setLog((Log)new WriterLog(streamsProxy.getOutputWriter()));
                QvtLaunchConfigurationDelegateBase.doLaunch(qvtTransformation, configuration, (IContext)context);
                qvtTransformation.cleanup();
            }
        };
        r = InMemoryQvtLaunchConfigurationDelegate.getSafeRunnable(qvtTransformation, r);
        ShallowProcess process = new ShallowProcess(launch, r);
        process.setStreamsProxy((IStreamsProxy)streamsProxy);
        final EmptyDebugTarget debugTarget = new EmptyDebugTarget(launch, (IProcess)process, "org.eclipse.m2m.qvt.oml.runtime", "QVTO");
        Job job = this.createTransformationJob(qvtTransformation, process, debugTarget, doneAction);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                try {
                    debugTarget.terminate();
                }
                catch (DebugException e) {
                    Logger.getLogger().log(Logger.SEVERE, "Debug target termination for " + qvtTransformation + " failed", e);
                }
            }
        });
        job.schedule();
    }

    private Job createTransformationJob(final QvtTransformation transformation, final ShallowProcess process, final EmptyDebugTarget debugTarget, final Runnable doneAction) {
        Job job = new Job(Messages.InMemoryQvtLaunchConfigurationDelegate_TransformationJobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.InMemoryQvtLaunchConfigurationDelegate_RunningTaskName, -1);
                try {
                    try {
                        process.run((IDebugTarget)debugTarget);
                        IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(statusJobDone);
                        if (statusHandler != null) {
                            Object[] handlerArgs = new Object[]{this, doneAction};
                            Object resolution = statusHandler.handleStatus(statusJobDone, (Object)handlerArgs);
                            if (!$assertionsDisabled && resolution == null) {
                                throw new AssertionError((Object)"Invalid job done status resolution");
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger().log(Logger.SEVERE, "Transformation " + transformation + " failed", e);
                        IStatus iStatus = MiscUtil.makeErrorStatus(StatusUtil.getExceptionMessages((Throwable)e), e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        return job;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new IProject[0];
    }
}

