/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.NonOverrideRelation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.NonTopOverrideRelation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.TopOverrideRelation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class RelationalTransformation2TracePackage
extends QVTbaseHelper {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull QVTrNameGenerator nameGenerator;
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull RelationalTransformation rTransformation;
    private final @NonNull Package tracePackage;
    protected final @NonNull Map<@NonNull String, @NonNull Relation2MiddleType> name2relation2middleType = new HashMap<String, Relation2MiddleType>();
    protected final @NonNull Map<@NonNull Relation, @NonNull Relation2TraceClass> relation2relation2traceClass = new HashMap<Relation, Relation2TraceClass>();
    private @NonNull Map<@NonNull Type, @NonNull Relation2MiddleType> middleClass2relation2middleType = new HashMap<Type, Relation2MiddleType>();
    private boolean frozen = false;

    public RelationalTransformation2TracePackage(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull TransformationAnalysis transformationAnalysis) {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.nameGenerator = qvtr2qvtc.getNameGenerator();
        this.transformationAnalysis = transformationAnalysis;
        this.rTransformation = transformationAnalysis.getTransformation();
        this.tracePackage = this.createTracePackage();
    }

    public @Nullable Property basicGetTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) {
        Relation2MiddleType relation2TraceClass = this.middleClass2relation2middleType.get(aClass);
        if (relation2TraceClass == null) {
            return null;
        }
        return relation2TraceClass.basicGetTraceProperty(rVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Class createClass(@NonNull Relation2MiddleType relation2middleType, @NonNull String className) {
        @NonNull List traceClasses = QVTrelationUtil.Internal.getOwnedClassesList((Package)this.tracePackage);
        String uniqueName = QVTrNameGenerator.getUniqueName(this.name2relation2middleType, className, relation2middleType);
        Class traceClass = PivotUtil.createClass((String)uniqueName);
        traceClasses.add(traceClass);
        this.middleClass2relation2middleType.put((Type)traceClass, relation2middleType);
        this.name2relation2middleType.put(uniqueName, relation2middleType);
        return traceClass;
    }

    protected @NonNull Package createTracePackage() {
        Package rPackage = this.rTransformation.getOwningPackage();
        Package tracePackage = PivotFactory.eINSTANCE.createPackage();
        tracePackage.setName("trace_" + this.rTransformation.getName());
        tracePackage.setNsPrefix("P" + this.rTransformation.getName());
        StringBuilder sURI = new StringBuilder();
        this.getURI(rPackage, sURI);
        tracePackage.setURI(String.valueOf(sURI.toString()) + "/" + this.rTransformation.getName());
        return tracePackage;
    }

    public void freeze() {
        this.frozen = true;
    }

    protected @NonNull Class getBagType(@NonNull Class traceClass) {
        return this.qvtr2qvtc.getEnvironmentFactory().getCompleteEnvironment().getBagType((Type)traceClass, true, null, null);
    }

    public @NonNull Class getBooleanType() {
        return this.qvtr2qvtc.getStandardLibrary().getBooleanType();
    }

    public @NonNull DomainUsageAnalysis getDomainUsageAnalysis() {
        return this.transformationAnalysis.getDomainUsageAnalysis();
    }

    public @NonNull QVTrNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    protected @NonNull Property getProperty(Type aClass, String name) throws CompilerChainException {
        assert (aClass != null && name != null);
        CompleteClass completeClass = this.getCompleteClass(aClass);
        Property p = completeClass.getProperty(name);
        if (p != null) {
            return p;
        }
        throw new CompilerChainException("No property '" + name + "' in '" + aClass + "::" + "'", new Object[0]);
    }

    public @NonNull Relation2TraceClass getRelation2TraceClass(@NonNull Relation rRelation) {
        Relation2TraceClass relation2traceClass = this.relation2relation2traceClass.get(rRelation);
        if (relation2traceClass == null) {
            TransformationAnalysis rTransformationAnalysis = this.qvtr2qvtc.getTransformationAnalysis(this.rTransformation);
            RelationAnalysis relationAnalysis = rTransformationAnalysis.getRelationAnalysis(rRelation);
            relation2traceClass = !QVTrelationUtil.hasOverrides((Relation)rRelation) ? new NonOverrideRelation2TraceClass(relationAnalysis) : (rRelation.isIsTopLevel() ? new TopOverrideRelation2TraceClass(relationAnalysis) : new NonTopOverrideRelation2TraceClass(relationAnalysis));
            this.relation2relation2traceClass.put(rRelation, relation2traceClass);
        }
        return relation2traceClass;
    }

    public @NonNull Property getSignatureProperty(@NonNull Relation rInvokedRelation, @NonNull VariableDeclaration rVariable) {
        throw new UnsupportedOperationException();
    }

    public @NonNull Class getTraceClass(@NonNull Relation rRelation) {
        return this.getRelation2TraceClass(rRelation).getMiddleClass();
    }

    public @NonNull Package getTracePackage() {
        return this.tracePackage;
    }

    public @NonNull Property getTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) throws CompilerChainException {
        Property property = this.basicGetTraceProperty(aClass, rVariable);
        if (property != null) {
            return property;
        }
        property = this.getProperty(aClass, rVariable.getName());
        if (rVariable instanceof Property) assert (rVariable == property);
        return property;
    }

    private String getURI(Package rPackage, @NonNull StringBuilder s) {
        if (rPackage == null) {
            s.append("http://www.eclipse.org/qvtd-example");
        } else if (rPackage.getURI() != null) {
            s.append(rPackage.getURI());
        } else {
            this.getURI(rPackage.getOwningPackage(), s);
            s.append("/");
            s.append(rPackage.getName());
        }
        return null;
    }

    public @NonNull VariableDeclaration2TraceProperty getVariableDeclaration2TraceProperty(@NonNull VariableDeclaration rVariable) {
        Relation2TraceClass relation2TraceClass = this.getRelation2TraceClass(QVTrelationUtil.getContainingRelation((EObject)rVariable));
        return relation2TraceClass.getVariableDeclaration2TraceProperty(rVariable);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public @NonNull String toString() {
        return String.valueOf(this.rTransformation);
    }

    public @NonNull Package transform() throws CompilerChainException {
        for (Relation rRelation : QVTrelationUtil.getOwnedRelations((RelationalTransformation)this.rTransformation)) {
            this.getRelation2TraceClass(rRelation);
        }
        ArrayList<@NonNull Relation2MiddleType> relation2middleTypes = new ArrayList<Relation2MiddleType>(this.name2relation2middleType.values());
        Collections.sort(relation2middleTypes, OverrideDepthComparator.INSTANCE);
        for (Relation2MiddleType relation2middleType : relation2middleTypes) {
            relation2middleType.analyze();
        }
        for (Relation2MiddleType relation2middleType : relation2middleTypes) {
            relation2middleType.synthesize();
        }
        CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedClassesList((Package)this.tracePackage));
        return this.tracePackage;
    }

    static class OverrideDepthComparator
    implements Comparator<Relation2MiddleType> {
        public static final @NonNull OverrideDepthComparator INSTANCE = new OverrideDepthComparator();

        OverrideDepthComparator() {
        }

        @Override
        public int compare(@NonNull Relation2MiddleType o1, @NonNull Relation2MiddleType o2) {
            int d2;
            int d1 = this.getDepth(o1);
            if (d1 != (d2 = this.getDepth(o2))) {
                return d1 - d2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }

        private int getDepth(@NonNull Relation2MiddleType relation2middleType) {
            int depth = 0;
            Relation aRule = relation2middleType.getRelation();
            while ((aRule = aRule.getOverridden()) != null) {
                ++depth;
            }
            return depth;
        }
    }
}

