/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.Set;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;

public abstract class ASMModel
extends ASMOclAny {
    private ModelLoader ml;
    public static ASMOclType myType = new ASMOclSimpleType("Model", ASMModel.getOclAnyType());
    private String name;
    private ASMModel metamodel;
    private boolean isTarget;

    public ModelLoader getModelLoader() {
        return this.ml;
    }

    public ASMModel(String name, ASMModel metamodel, boolean isTarget, ModelLoader ml) {
        super(myType);
        this.name = name;
        this.ml = ml;
        this.metamodel = metamodel == null ? this : metamodel;
        this.isTarget = isTarget;
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + this.metamodel.name;
    }

    public Set getElementsByType(String typeName) {
        return this.getElementsByType(this.getMetamodel().findModelElement(typeName));
    }

    public abstract Set getElementsByType(ASMModelElement var1);

    public abstract ASMModelElement findModelElement(String var1);

    public ASMModelElement newModelElement(String typeName) {
        return this.newModelElement(null, typeName);
    }

    public ASMModelElement newModelElement(StackFrame frame, String typeName) {
        ASMModelElement type = this.getMetamodel().findModelElement(typeName);
        if (type == null) {
            String msg = "No type named '" + typeName + "' in metamodel '" + this.metamodel.name + "'";
            if (frame == null) {
                ATLLogger.severe((String)msg);
            } else {
                frame.printStackTrace(msg);
            }
        }
        return this.newModelElement(type);
    }

    public abstract ASMModelElement newModelElement(ASMModelElement var1);

    public String getName() {
        return this.name;
    }

    public ASMModel getMetamodel() {
        return this.metamodel;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public void setIsTarget(boolean isTarget) {
        this.isTarget = isTarget;
    }
}

