/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.uml2.uml.Package;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractReconnectSourceEdgeTests
extends AbstractSiriusDiagramTests {
    protected Package root;
    private EObject semanticSource;
    private EObject semanticTarget;
    private EObject semanticNewSource;
    private EObject edgeSource;
    private EObject edgeTarget;
    private EObject edgeNewSource;

    @Before
    public void setUp() {
        this.root = this.fixture.getModel();
    }

    protected void reconnectSourceEdge(String reconnectionSourceToolId, DEdge edge) {
        this.reconnectSourceEdge(reconnectionSourceToolId, edge, false);
    }

    protected void reconnectSourceEdge(String reconnectionSourceToolId, DEdge edge, boolean isSynchronized) {
        this.checkSiriusDiagramSynchronization(isSynchronized);
        Diagram diagram = this.getDiagram();
        int initalNbEdges = diagram.getEdges().size();
        EClass initialEdgeType = edge.getTarget().eClass();
        boolean result = this.fixture.applyEdgeReconnectionTool(reconnectionSourceToolId, (DDiagram)this.getDDiagram(), edge, (EdgeTarget)this.getEdgeSource(), (EdgeTarget)this.getEdgeNewSource());
        Assert.assertTrue((String)"The reconnexion of edge failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"Number of edge on diagram should not be different after reconnexion.", (long)initalNbEdges, (long)diagram.getEdges().size());
        Assert.assertEquals((String)"Edge target should not change.", (Object)((EdgeTarget)this.getEdgeTarget()), (Object)edge.getTargetNode());
        Assert.assertEquals((String)"New edge source does not match with reconnection source.", (Object)((EdgeTarget)this.getEdgeNewSource()), (Object)edge.getSourceNode());
        EList semanticElements = edge.getSemanticElements();
        Assert.assertEquals((String)"The reconnected edge representation must have 1 associated semantic element", (long)1L, (long)semanticElements.size());
        EObject element = (EObject)semanticElements.get(0);
        Assert.assertEquals((String)"The type of the reconnected edge should not change.", (Object)initialEdgeType, (Object)element.eClass());
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        Assert.assertEquals((String)"The semantic target should not change.", (Object)this.getSemanticTarget(), domainBasedEdgeServices.getTargets(element).get(0));
        Assert.assertEquals((String)"The semantic source does not match with reconnection semantic source.", (Object)this.getSemanticNewSource(), (Object)domainBasedEdgeServices.getSource(element));
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"The semantic source should be reseted.", (Object)this.getSemanticSource(), (Object)domainBasedEdgeServices.getSource(element));
        Assert.assertEquals((String)"The semantic target should not change.", (Object)this.getSemanticTarget(), domainBasedEdgeServices.getTargets(element).get(0));
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"The semantic target should not change.", (Object)this.getSemanticTarget(), domainBasedEdgeServices.getTargets(element).get(0));
        Assert.assertEquals((String)"The semantic source does not match with reconnection semantic source.", (Object)this.getSemanticNewSource(), (Object)domainBasedEdgeServices.getSource(element));
    }

    @After
    public void tearDown() {
        this.root = null;
    }

    public EObject getSemanticSource() {
        return this.semanticSource;
    }

    public void setSemanticSource(EObject semanticSource) {
        this.semanticSource = semanticSource;
    }

    public EObject getSemanticTarget() {
        return this.semanticTarget;
    }

    public void setSemanticTarget(EObject semanticTarget) {
        this.semanticTarget = semanticTarget;
    }

    public EObject getSemanticNewSource() {
        return this.semanticNewSource;
    }

    public void setSemanticNewSource(EObject semanticNewSource) {
        this.semanticNewSource = semanticNewSource;
    }

    public EObject getEdgeSource() {
        return this.edgeSource;
    }

    public void setEdgeSource(EObject edgeSource) {
        this.edgeSource = edgeSource;
    }

    public EObject getEdgeTarget() {
        return this.edgeTarget;
    }

    public void setEdgeTarget(EObject edgeTarget) {
        this.edgeTarget = edgeTarget;
    }

    public EObject getEdgeNewSource() {
        return this.edgeNewSource;
    }

    public void setEdgeNewSource(EObject edgeNewSource) {
        this.edgeNewSource = edgeNewSource;
    }
}

