/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.papyrus.infra.tools.util.Try;

final class Success<T>
extends Try<T> {
    private static final long serialVersionUID = -6184897525442822648L;
    private final T value;

    Success(T value) {
        this.value = value;
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public String reason() {
        return null;
    }

    @Override
    public Throwable failure() {
        return null;
    }

    @Override
    public <U> Try<U> map(Function<? super T, U> mapping) {
        return this.isEmpty() ? Success.empty() : Success.success(mapping.apply(this.value));
    }

    @Override
    public <U> Try<U> flatMap(Function<? super T, Optional<U>> mapping) {
        return this.isEmpty() ? Success.empty() : Success.success(mapping.apply(this.value).orElse(null));
    }

    @Override
    public <U> Try<U> tryMap(Function<? super T, Try<U>> mapping) {
        return this.isEmpty() ? Success.empty() : Objects.requireNonNull(mapping.apply(this.value));
    }

    @Override
    public Try<T> filter(Predicate<? super T> test) {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Success)) {
            return false;
        }
        Success other = (Success)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(Success.class, this.value);
    }

    public String toString() {
        return this.isEmpty() ? "Empty()" : String.format("Success(%s)", this.value);
    }
}

