/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerMutator;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CollectionTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.OrderedSetTypeOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.SetTypeOperations;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.TypeUtil;

public class ListOperations
extends AbstractContextualOperations {
    static final String ADD_NAME = "add";
    static final String REMOVE_NAME = "remove";
    static final String REMOVE_ALL_NAME = "removeAll";
    static final String REMOVE_AT_NAME = "removeAt";
    static final String REMOVE_FIRST_NAME = "removeFirst";
    static final String REMOVE_LAST_NAME = "removeLast";
    static final String JOINFIELDS_NAME = "joinfields";
    static final String SELECT_BY_TYPE_NAME = "selectByType";
    static final String SELECT_BY_KIND_NAME = "selectByKind";
    static CallHandler ADD = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList && args.length > 0) {
                List list = (List)source;
                Object element = args[0];
                if (element != CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    list.add(element);
                }
                return list;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler INSERT_AT_VOID = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList && args.length > 1 && args[1] instanceof Integer) {
                MutableList list = (MutableList)source;
                Object element = args[0];
                if (element != CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    list.insertAt(element, (Integer)args[1]);
                }
                return list;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler REMOVE = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList && args.length > 0) {
                List list = (List)source;
                Object element = args[0];
                if (element != CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    list.removeAll(Collections.singleton(element));
                }
                return list;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler REMOVE_ALL = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList && args.length > 0 && args[0] instanceof Collection) {
                List list = (List)source;
                list.removeAll((Collection)args[0]);
                return list;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler REMOVE_AT = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList && args.length > 0 && args[0] instanceof Integer) {
                List list = (List)source;
                int index = (Integer)args[0] - 1;
                if (index < 0 || index >= list.size()) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return list.remove(index);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler REMOVE_FIRST = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList) {
                List list = (List)source;
                if (list.isEmpty()) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return list.remove(0);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler REMOVE_LAST = new CallHandlerMutator(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList) {
                List list = (List)source;
                if (list.isEmpty()) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return list.remove(list.size() - 1);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static CallHandler JOINFIELDS = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof MutableList && args.length > 2 && args[0] instanceof String && args[1] instanceof String && args[2] instanceof String) {
                MutableList list = (MutableList)source;
                String sep = (String)args[0];
                String begin = (String)args[1];
                String end = (String)args[2];
                return list.joinfields(sep, begin, end);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler FIRST = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                if (((Collection)source).isEmpty()) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return CollectionUtil.first((Collection)((Collection)source));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler LAST = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                if (((Collection)source).isEmpty()) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return CollectionUtil.last((Collection)((Collection)source));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler AT = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof Integer) {
                int index = (Integer)args[0] - 1;
                if (index < 0 || index >= ((Collection)source).size()) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return CollectionUtil.at((Collection)((Collection)source), (int)((Integer)args[0]));
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler CLONE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                return Utils.createList((Collection)source);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler SELECT_BY_TYPE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof EClassifier) {
                MutableList result = Utils.createList();
                EClassifier type = (EClassifier)args[0];
                for (Object object : (Collection)source) {
                    if (!evalEnv.isTypeOf(object, type)) continue;
                    result.add(object);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler SELECT_BY_KIND = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0 && args[0] instanceof EClassifier) {
                MutableList result = Utils.createList();
                EClassifier type = (EClassifier)args[0];
                for (Object object : (Collection)source) {
                    if (!evalEnv.isKindOf(object, type)) continue;
                    result.add(object);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static CallHandler SUB_SEQUENCE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 1 && args[0] instanceof Integer && args[1] instanceof Integer) {
                MutableList result = CollectionUtil.subSequence((Collection)((Collection)source), (int)((Integer)args[0]), (int)((Integer)args[1]));
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };

    public ListOperations(AbstractQVTStdlib library) {
        super(library, library.getList());
    }

    @Override
    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary<EClassifier> oclStdlib = this.getStdlib().getOCLStdLib();
        ListType listOfT2 = this.getStdlib().getEnvironment().getTypeResolver().resolveListType((EClassifier)oclStdlib.getT2());
        ListType listOfCommonT = this.getStdlib().getEnvironment().getTypeResolver().resolveListType(this.getStdlib().getCommonT());
        EClassifier collectionOfT2 = (EClassifier)TypeUtil.resolveCollectionType((Environment)this.getStdlib().getEnvironment(), (CollectionKind)CollectionKind.COLLECTION_LITERAL, (Object)((EClassifier)oclStdlib.getT2()));
        return new AbstractContextualOperations.OperationProvider[]{new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, ADD, ADD_NAME, new String[]{"object"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, UNSUPPORTED_OPER, ADD_NAME, new String[]{"obj", "List(T)::add(object:T2) is supported only for case T2_isSubtypeOf_T"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, INSERT_AT_VOID, "insertAt", new String[]{"object", "index"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT(), (EClassifier)oclStdlib.getInteger()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, REMOVE, REMOVE_NAME, new String[]{"element"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, REMOVE_ALL, REMOVE_ALL_NAME, new String[]{"elements"}, (EClassifier)oclStdlib.getOclVoid(), collectionOfT2), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, REMOVE_AT, REMOVE_AT_NAME, new String[]{"index"}, (EClassifier)oclStdlib.getT(), (EClassifier)oclStdlib.getInteger()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, REMOVE_FIRST, REMOVE_FIRST_NAME, (EClassifier)oclStdlib.getT(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, REMOVE_LAST, REMOVE_LAST_NAME, (EClassifier)oclStdlib.getT(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, JOINFIELDS, JOINFIELDS_NAME, new String[]{"sep", "begin", "end"}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, FIRST, "first", (EClassifier)oclStdlib.getT(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, LAST, "last", (EClassifier)oclStdlib.getT(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, AT, "at", new String[]{"i"}, (EClassifier)oclStdlib.getT(), (EClassifier)oclStdlib.getInteger()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, CLONE, "clone", this.getStdlib().getList(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, UNSUPPORTED_OPER, "deepclone", new String[]{"List(T)::deepclone() is not supported yet"}, this.getStdlib().getList(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, SELECT_BY_TYPE, SELECT_BY_TYPE_NAME, new String[]{"type"}, this.getStdlib().getList(), (EClassifier)oclStdlib.getOclType()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, SELECT_BY_KIND, SELECT_BY_KIND_NAME, new String[]{"type"}, this.getStdlib().getList(), (EClassifier)oclStdlib.getOclType()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, SUB_SEQUENCE, "subSequence", new String[]{"lower", "upper"}, this.getStdlib().getList(), (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getInteger()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, CollectionTypeOperations.FLATTEN, "flatten", (EClassifier)listOfT2, new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, SetTypeOperations.INCLUDING, "including", new String[]{"object"}, (EClassifier)listOfCommonT, (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, SetTypeOperations.EXCLUDING, "excluding", new String[]{"object"}, this.getStdlib().getList(), (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, SetTypeOperations.UNION, "union", new String[]{"s"}, (EClassifier)listOfCommonT, new EClassifier[]{listOfT2}), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, OrderedSetTypeOperations.REVERSE, "reverse", this.getStdlib().getList(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, OrderedSetTypeOperations.APPEND, "append", new String[]{"object"}, (EClassifier)listOfCommonT, (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, OrderedSetTypeOperations.PREPEND, "prepend", new String[]{"object"}, (EClassifier)listOfCommonT, (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, OrderedSetTypeOperations.INSERT_AT, "insertAt", new String[]{"index", "object"}, (EClassifier)listOfCommonT, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getT2()), new AbstractContextualOperations.OperationProvider((AbstractContextualOperations)this, OrderedSetTypeOperations.INDEX_OF, "indexOf", new String[]{"object"}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getT2())};
    }
}

