/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.helper.advice;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class CollaborationHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyReferenceCommand(DestroyReferenceRequest request) {
        EObject elementToEdit = request.getContainer();
        HashSet<View> viewsToDelete = new HashSet<View>();
        if (elementToEdit instanceof Collaboration && request.getContainingFeature() == UMLPackage.eINSTANCE.getCollaboration_CollaborationRole()) {
            ConnectableElement refRole = (ConnectableElement)request.getReferencedObject();
            Collaboration collaborationToEdit = (Collaboration)elementToEdit;
            viewsToDelete.addAll(this.getViewsForRole(refRole, collaborationToEdit));
        }
        if (viewsToDelete != null && !viewsToDelete.isEmpty()) {
            DestroyDependentsRequest req = new DestroyDependentsRequest(request.getEditingDomain(), elementToEdit, false);
            req.setClientContext(request.getClientContext());
            req.addParameters(request.getParameters());
            return req.getDestroyDependentsCommand(viewsToDelete);
        }
        return null;
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        EObject elementToEdit = request.getElementToEdit();
        HashSet<View> viewsToDelete = new HashSet<View>();
        if (elementToEdit instanceof Collaboration && request.getFeature() == UMLPackage.eINSTANCE.getCollaboration_CollaborationRole()) {
            Collaboration collaborationToEdit = (Collaboration)elementToEdit;
            HashSet removedRoles = new HashSet();
            removedRoles.addAll(collaborationToEdit.getRoles());
            if (request.getValue() instanceof ConnectableElement) {
                removedRoles.remove(request.getValue());
            } else if (request.getValue() instanceof List) {
                removedRoles.removeAll((List)request.getValue());
            }
            for (ConnectableElement currentRole : removedRoles) {
                viewsToDelete.addAll(this.getViewsForRole(currentRole, collaborationToEdit));
            }
        }
        if (viewsToDelete != null && !viewsToDelete.isEmpty()) {
            DestroyDependentsRequest req = new DestroyDependentsRequest(request.getEditingDomain(), elementToEdit, false);
            req.setClientContext(request.getClientContext());
            req.addParameters(request.getParameters());
            return req.getDestroyDependentsCommand(viewsToDelete);
        }
        return null;
    }

    private Set<View> getViewsForRole(ConnectableElement role, Collaboration modifiedCollaboration) {
        HashSet<View> viewsToDelete = new HashSet<View>();
        Set collaborationToEditViews = CrossReferencerUtil.getCrossReferencingViews((EObject)modifiedCollaboration, (String)"CompositeStructure");
        for (View currentCollaborationView : collaborationToEditViews) {
            TreeIterator it = currentCollaborationView.eAllContents();
            while (it.hasNext()) {
                EObject currentChildObject = (EObject)it.next();
                if (!(currentChildObject instanceof View)) continue;
                View currentChildView = (View)currentChildObject;
                if (!((IHintedType)UMLElementTypes.ConnectableElement_CollaborationRoleShape).getSemanticHint().equals(currentChildView.getType()) || currentChildView.getElement() != role) continue;
                viewsToDelete.add(currentChildView);
            }
        }
        return viewsToDelete;
    }
}

