/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import org.eclipse.xwt.animation.internal.ITimeline;

public class AnimationManager {
    private WeakHashMap<Object, ScenarioManager> scenarioManagers = new WeakHashMap();
    private static AnimationManager INSTANCE;

    public static AnimationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnimationManager();
        }
        return INSTANCE;
    }

    public void play(ITimeline timeline) {
        ScenarioManager manager = this.scenarioManagers.get(timeline.getTarget());
        if (manager != null) {
            manager.play(timeline);
        }
    }

    public void stop(ITimeline timeline) {
        ScenarioManager manager = this.scenarioManagers.get(timeline.getTarget());
        if (manager != null) {
            manager.cancel(timeline);
        }
    }

    public void pause(ITimeline timeline) {
        ScenarioManager manager = this.scenarioManagers.get(timeline.getTarget());
        if (manager != null) {
            manager.pause(timeline);
        }
    }

    public void resume(ITimeline timeline) {
        ScenarioManager manager = this.scenarioManagers.get(timeline.getTarget());
        if (manager != null) {
            manager.resume(timeline);
        }
    }

    public void playReverse(ITimeline timeline) {
        ScenarioManager manager = this.scenarioManagers.get(timeline.getTarget());
        if (manager != null) {
            manager.playReverse(timeline);
        }
    }

    public void addTimeline(ITimeline timeline) {
        ScenarioManager manager = this.scenarioManagers.get(timeline.getTarget());
        if (manager == null) {
            manager = new ScenarioManager();
            this.scenarioManagers.put(timeline.getTarget(), manager);
        }
        manager.addTimeline(timeline);
    }

    static class ScenarioManager {
        private Collection<ITimeline> timelines = new ArrayList<ITimeline>();

        ScenarioManager() {
        }

        public void play(ITimeline timeline) {
            for (ITimeline timelineScenario : this.timelines) {
                if (timelineScenario == timeline) continue;
                timelineScenario.cancel();
            }
            timeline.play();
        }

        public void cancel(ITimeline timeline) {
            timeline.end();
        }

        public void pause(ITimeline timeline) {
            timeline.pause();
        }

        public void resume(ITimeline timeline) {
            timeline.resume();
        }

        public void playReverse(ITimeline timeline) {
            timeline.playReverse();
        }

        public void addTimeline(ITimeline timeline) {
            this.timelines.add(timeline);
        }
    }
}

