/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PapyrusEEFExtContainerSelectionPage
extends WizardPage {
    private static final String EMPTY_STRING = "";
    private static final String REFERENCE_LABEL = "Reference: ";
    private static final String CONTAINER_LABEL = "Container: ";
    private static final String PAGE_NAME = "Container and Reference Selection";
    private static final String PAGE_TITLE = "Choose the container and reference";
    private static final String PAGE_DESCRIPTION = "Select the container and reference which will contain the object to create";
    private static final String BROWSE_CONTAINER_DIALOG_TITLE = "Browse container";
    private static final String BROWSE_REFERENCE_DIALOG_TITLE = "Browse reference";
    private EObject target;
    private int returnCode = 1;
    private EEFWidgetFactory widgetFactory;
    private EClass eClassToCreate;
    private EObject eContainer;
    private EStructuralFeature eContainerFeature;
    private LineComposite containerComposite;
    private LineComposite referenceComposite;
    private UMLFilteredLabelProvider containerLabelProvider;
    private EMFLabelProvider referenceLabelProvider;

    public PapyrusEEFExtContainerSelectionPage(EObject target) {
        super(PAGE_NAME);
        this.target = target;
        this.widgetFactory = new EEFWidgetFactory();
        this.containerLabelProvider = new UMLFilteredLabelProvider();
        this.referenceLabelProvider = new EMFLabelProvider();
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        GridLayout gridLayout = new GridLayout(1, false);
        control.setLayout((Layout)gridLayout);
        this.createContainerComposite(control);
        this.createReferenceComposite(control);
    }

    private void createContainerComposite(Composite parentControl) {
        this.containerComposite = this.createLine(parentControl, CONTAINER_LABEL);
        this.containerComposite.removeButton.setEnabled(false);
        this.containerComposite.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusEEFExtContainerSelectionPage.this.browseContainerDialog();
                if (PapyrusEEFExtContainerSelectionPage.this.eContainer != null) {
                    PapyrusEEFExtContainerSelectionPage.this.updateEContainerFeature();
                    PapyrusEEFExtContainerSelectionPage.this.updateMainComposite();
                }
                PapyrusEEFExtContainerSelectionPage.this.setPageComplete(PapyrusEEFExtContainerSelectionPage.this.isPageComplete());
            }
        });
        this.containerComposite.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusEEFExtContainerSelectionPage.this.eContainer = null;
                PapyrusEEFExtContainerSelectionPage.this.eContainerFeature = null;
                PapyrusEEFExtContainerSelectionPage.this.updateMainComposite();
                PapyrusEEFExtContainerSelectionPage.this.setPageComplete(PapyrusEEFExtContainerSelectionPage.this.isPageComplete());
            }
        });
    }

    private void createReferenceComposite(Composite parentControl) {
        this.referenceComposite = this.createLine(parentControl, REFERENCE_LABEL);
        this.referenceComposite.browseButton.setEnabled(false);
        this.referenceComposite.removeButton.setEnabled(false);
        this.referenceComposite.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusEEFExtContainerSelectionPage.this.browseReferenceDialog();
                PapyrusEEFExtContainerSelectionPage.this.updateMainComposite();
                PapyrusEEFExtContainerSelectionPage.this.setPageComplete(PapyrusEEFExtContainerSelectionPage.this.isPageComplete());
            }
        });
        this.referenceComposite.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusEEFExtContainerSelectionPage.this.eContainerFeature = null;
                PapyrusEEFExtContainerSelectionPage.this.updateMainComposite();
                PapyrusEEFExtContainerSelectionPage.this.setPageComplete(PapyrusEEFExtContainerSelectionPage.this.isPageComplete());
            }
        });
    }

    private void updateMainComposite() {
        if (this.eContainer == null) {
            this.containerComposite.cLabel.setText(EMPTY_STRING);
            this.containerComposite.cLabel.setImage(null);
            this.containerComposite.removeButton.setEnabled(false);
        } else {
            this.containerComposite.cLabel.setImage(this.containerLabelProvider.getImage((Object)this.eContainer));
            this.containerComposite.cLabel.setText(this.containerLabelProvider.getText((Object)this.eContainer));
            this.containerComposite.removeButton.setEnabled(true);
        }
        if (this.eContainerFeature == null) {
            this.referenceComposite.cLabel.setText(EMPTY_STRING);
            this.referenceComposite.removeButton.setEnabled(false);
        } else {
            this.referenceComposite.cLabel.setText(this.referenceLabelProvider.getText((Object)this.eContainerFeature));
            this.referenceComposite.removeButton.setEnabled(true);
        }
    }

    private void updateEContainerFeature() {
        FeatureContentProvider referenceContentProvider = new FeatureContentProvider(this.eClassToCreate);
        referenceContentProvider.inputChanged(null, null, (Object)this.eContainer);
        if (referenceContentProvider.getElements().length == 0) {
            this.eContainerFeature = null;
        } else if (referenceContentProvider.getElements().length == 1) {
            this.eContainerFeature = (EStructuralFeature)referenceContentProvider.getElements()[0];
        } else if (!Arrays.asList(referenceContentProvider.getElements()).contains(this.eContainerFeature)) {
            this.eContainerFeature = null;
        }
        this.referenceComposite.setReadOnly(referenceContentProvider.getElements().length < 2);
    }

    protected void browseContainerDialog() {
        Object[] result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
        dialog.setLabelProvider((ILabelProvider)this.containerLabelProvider);
        UMLContainerContentProvider containerContentProvider = new UMLContainerContentProvider(this.target, this.eClassToCreate);
        EMFGraphicalContentProvider graphicalContentProvider = ProviderHelper.encapsulateProvider((ITreeContentProvider)containerContentProvider, (ResourceSet)this.target.eResource().getResourceSet(), null);
        dialog.setContentProvider((ITreeContentProvider)graphicalContentProvider);
        dialog.setInitialElementSelections(Collections.singletonList(null));
        dialog.setTitle(BROWSE_CONTAINER_DIALOG_TITLE);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && result[0] instanceof EObject) {
            this.eContainer = (EObject)result[0];
        }
    }

    protected void browseReferenceDialog() {
        Object[] result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
        dialog.setLabelProvider((ILabelProvider)this.referenceLabelProvider);
        dialog.setInput((Object)this.eContainer);
        FeatureContentProvider referenceContentProvider = new FeatureContentProvider(this.eClassToCreate);
        referenceContentProvider.inputChanged(null, null, (Object)this.eContainer);
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)referenceContentProvider));
        dialog.setInitialElementSelections(Collections.singletonList(null));
        dialog.setTitle(BROWSE_REFERENCE_DIALOG_TITLE);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && result[0] instanceof EStructuralFeature) {
            this.eContainerFeature = (EStructuralFeature)result[0];
        }
    }

    public void performFinish(IProgressMonitor monitor) {
        this.returnCode = 0;
    }

    protected LineComposite createLine(Composite parent, String labelValue) {
        LineComposite line = new LineComposite(parent, 0);
        line.setLayoutData(new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(4, false);
        line.setLayout((Layout)gridLayout);
        Label label = this.widgetFactory.createLabel((Composite)line, labelValue, 0);
        CLabel cLabel = this.widgetFactory.createCLabel((Composite)line, EMPTY_STRING, 2048);
        GridData cLabelGridData = new GridData(4, 1, true, false);
        cLabel.setLayoutData((Object)cLabelGridData);
        Button browseButton = new Button((Composite)line, 0);
        Image browseImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Browse_16x16.gif"));
        browseButton.setImage(browseImage);
        Button removeButton = new Button((Composite)line, 0);
        Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Delete_16x16.gif"));
        removeButton.setImage(removeImage);
        line.label = label;
        line.cLabel = cLabel;
        line.browseButton = browseButton;
        line.removeButton = removeButton;
        return line;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setEClassToCreate(EClass selectedEClass) {
        this.eClassToCreate = selectedEClass;
    }

    public EClass getEClassToCreate() {
        return this.eClassToCreate;
    }

    public EObject getEContainer() {
        return this.eContainer;
    }

    public EStructuralFeature getEContainerFeature() {
        return this.eContainerFeature;
    }

    public boolean isPageComplete() {
        return this.eContainer != null && this.eContainerFeature != null;
    }

    public void reset() {
        this.eContainer = null;
        this.eContainerFeature = null;
        this.updateMainComposite();
    }

    protected class LineComposite
    extends Composite {
        protected Label label;
        protected CLabel cLabel;
        protected Button browseButton;
        protected Button removeButton;

        LineComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void setReadOnly(boolean isReadOnly) {
            this.browseButton.setEnabled(!isReadOnly);
            this.removeButton.setEnabled(!isReadOnly);
        }
    }
}

