/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.architecture.commands.IModelCommandProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public class ModelCommandProviderRegistry
implements IModelCommandProvider {
    private static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.infra.architecture.commandProviders";
    private static final String PROVIDER_CLASS = "class";
    private static ModelCommandProviderRegistry registry;
    private Collection<IModelCommandProvider> providers;

    public static synchronized ModelCommandProviderRegistry getInstance() {
        if (registry == null) {
            registry = new ModelCommandProviderRegistry();
            registry.init();
        }
        return registry;
    }

    @Override
    public Command getModelCreationCommand(ModelSet modelSet, String contextId) {
        CompoundCommand cc = new CompoundCommand("Contributions to Model Creation");
        for (IModelCommandProvider provider : this.providers) {
            cc.append(provider.getModelCreationCommand(modelSet, contextId));
        }
        return cc.isEmpty() ? null : cc;
    }

    @Override
    public Command getModelConversionCommand(ModelSet modelSet, String contextId) {
        CompoundCommand cc = new CompoundCommand("Contributions to Model Conversion");
        for (IModelCommandProvider provider : this.providers) {
            cc.append(provider.getModelConversionCommand(modelSet, contextId));
        }
        return cc.isEmpty() ? null : cc;
    }

    private void init() {
        IConfigurationElement[] elements;
        this.providers = new ArrayList<IModelCommandProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object providerClass = configurationElement.createExecutableExtension(PROVIDER_CLASS);
                if (providerClass instanceof IModelCommandProvider) {
                    this.providers.add((IModelCommandProvider)providerClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }
}

