/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.architecture.migration;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableReconciler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;

public class UMLTableReconciler_1_3_0
extends TableReconciler {
    private static final String VIEW_TABLE = "View Table";
    private static final String GENERIC_TREE_TABLE = "Generic Tree Table";
    private static final String CLASS_TREE_TABLE = "Class Tree Table";
    private static final String GENERIC_TABLE = "Generic Table";
    private static final String CLASS_TREE_TABLE_TYPE = "PapyrusClassTreeTable";
    private static final String GENERIC_TABLE_TYPE = "PapyrusGenericTable";
    private static final String GENERIC_TREE_TABLE_TYPE = "PapyrusUMLGenericTreeTable";
    private static final String VIEW_TABLE_TYPE = "PapyrusViewsTable";

    public ICommand getReconcileCommand(Table table) {
        PapyrusTable newTableKind = null;
        if (table.getTableConfiguration() != null) {
            String type = table.getTableConfiguration().getType();
            if (CLASS_TREE_TABLE_TYPE.equals(type)) {
                newTableKind = this.getTableKind(CLASS_TREE_TABLE, table);
            } else if (GENERIC_TABLE_TYPE.equals(type)) {
                newTableKind = this.getTableKind(GENERIC_TABLE, table);
            } else if (GENERIC_TREE_TABLE_TYPE.equals(type)) {
                newTableKind = this.getTableKind(GENERIC_TREE_TABLE, table);
            } else if (VIEW_TABLE_TYPE.equals(type)) {
                newTableKind = this.getTableKind(VIEW_TABLE, table);
            }
        }
        if (newTableKind != null) {
            return new ReplaceTablePrototypeCommand(table, (RepresentationKind)newTableKind);
        }
        return null;
    }

    protected PapyrusTable getTableKind(String name, Table table) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureDescriptionLanguage context = (MergedArchitectureDescriptionLanguage)manager.getArchitectureContextById("org.eclipse.papyrus.infra.services.edit.TypeContext");
        for (RepresentationKind pKind : context.getRepresentationKinds()) {
            PapyrusTable tKind;
            if (!pKind.getName().equals(name) || !((ModelRule)(tKind = (PapyrusTable)pKind).getModelRules().get(0)).getElement().isInstance((Object)table.getContext())) continue;
            return tKind;
        }
        return null;
    }

    protected class ReplaceTablePrototypeCommand
    extends AbstractCommand {
        private Table table;
        private RepresentationKind newKind;

        public ReplaceTablePrototypeCommand(Table table, RepresentationKind newKind) {
            super("Replace the papyrus view style from 1.0.0 to 1.3.0");
            this.table = table;
            this.newKind = newKind;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.table.setPrototype(null);
            this.table.setTableKindId(this.newKind.getId());
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

