/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.papyrus.infra.nattable.handler.AbstractMergeHandler;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeSelectedColumnsHandler
extends AbstractMergeHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompositeCommand mergeCommand = new CompositeCommand("Merge/UnMerge the cells in each selected columns");
        TransactionalEditingDomain tableDomain = this.getTableEditingDomain();
        BodyLayerStack bodyLayerStack = this.getCurrentNattableModelManager().getBodyLayerStack();
        String commandId = event.getCommand().getId();
        boolean isMerged = HandlerUtil.toggleCommandState((Command)event.getCommand());
        INattableModelManager manager = this.getCurrentNattableModelManager();
        int[] selectedColumns = bodyLayerStack.getSelectionLayer().getFullySelectedColumnPositions();
        List selectedCs = ArrayUtil.asIntegerList((int[])bodyLayerStack.getSelectionLayer().getFullySelectedColumnPositions());
        int idex = 0;
        ArrayList<Integer> mergedColumns = new ArrayList<Integer>();
        for (Object currentObject : manager.getColumnElementsList()) {
            if (!(currentObject instanceof IAxis)) continue;
            IAxis currentAxis = (IAxis)currentObject;
            BooleanValueStyle axisToMerge = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns");
            if (axisToMerge != null && axisToMerge.isBooleanValue()) {
                mergedColumns.add(idex);
            }
            ++idex;
        }
        if (!isMerged || isMerged && !selectedCs.equals(mergedColumns)) {
            ArrayList<IAxis> selectedColumnAxis = new ArrayList<IAxis>();
            int[] nArray = selectedColumns;
            int axisToMerge = selectedColumns.length;
            int n = 0;
            while (n < axisToMerge) {
                IAxis currentColumnIAxis;
                int index = nArray[n];
                Object currentColumnObject = this.getCurrentNattableModelManager().getColumnElement(index);
                if (currentColumnObject instanceof IAxis && (currentColumnIAxis = (IAxis)currentColumnObject).eContainer() != null) {
                    selectedColumnAxis.add(currentColumnIAxis);
                    BooleanValueStyle isSelected = (BooleanValueStyle)currentColumnIAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns");
                    if (isSelected != null) {
                        SetRequest mergeColumnRequest = new SetRequest(tableDomain, (EObject)isSelected, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)true);
                        mergeColumnCommand = new SetValueCommand(mergeColumnRequest);
                        mergeCommand.add((IUndoableOperation)mergeColumnCommand);
                    } else {
                        isSelected = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
                        isSelected.setBooleanValue(true);
                        isSelected.setName("mergeInSelectedColumns");
                        SetRequest initColumnMergeRequest = new SetRequest(tableDomain, (EObject)currentColumnIAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)isSelected);
                        mergeColumnCommand = new SetValueCommand(initColumnMergeRequest);
                        mergeCommand.add((IUndoableOperation)mergeColumnCommand);
                    }
                }
                ++n;
            }
            if (!selectedCs.equals(mergedColumns)) {
                Iterator iterator = mergedColumns.iterator();
                while (iterator.hasNext()) {
                    IAxis toUnMerge;
                    BooleanValueStyle isSelected;
                    int sel = (Integer)iterator.next();
                    if (selectedCs.contains(sel) || !(manager.getColumnElement(sel) instanceof IAxis) || (isSelected = (BooleanValueStyle)(toUnMerge = (IAxis)manager.getColumnElement(sel)).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns")) == null) continue;
                    SetRequest mergeColumnRequest = new SetRequest(tableDomain, (EObject)isSelected, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                    SetValueCommand mergeColumnCommand = new SetValueCommand(mergeColumnRequest);
                    mergeCommand.add((IUndoableOperation)mergeColumnCommand);
                }
                if (selectedCs.size() == 0) {
                    this.updateAxisSpanBooleans(commandId, mergeCommand);
                }
            }
        } else {
            this.updateAxisSpanBooleans(commandId, mergeCommand);
        }
        this.executeMergeCommands(mergeCommand, tableDomain);
        return null;
    }
}

