/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeGraphicalParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeModelParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.SetUpReferencesCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.UpdateReferencesCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.utlis.CommandsUtils;
import org.eclipse.papyrus.uml.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.DefaultModelParent;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.Utils;
import org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;

public class XYLayoutEditGroupPolicy
extends XYLayoutEditPolicy {
    private ArrayList<IGraphicalEditPart> graphicalParents;
    private ArrayList<IGraphicalEditPart> modelParents;
    private ArrayList<IGraphicalEditPart> oldGraphicalParents;
    private ArrayList<IGraphicalEditPart> oldModelParents;

    protected Object getConstraintFor(CreateRequest request) {
        if (request.getExtendedData().containsKey("Graphical_parent") && request.getExtendedData().containsKey("New_parent_host")) {
            IGraphicalEditPart graphicalParent = (IGraphicalEditPart)request.getExtendedData().get("Graphical_parent");
            IGraphicalEditPart newHost = (IGraphicalEditPart)request.getExtendedData().get("New_parent_host");
            Dimension delta = Utils.computeDeltaToChangeParent(newHost, graphicalParent);
            Rectangle rectangle = (Rectangle)super.getConstraintFor(request);
            rectangle.translate(delta.width, delta.height);
            return rectangle;
        }
        return super.getConstraintFor(request);
    }

    public Command getCommand(Request request) {
        if (this.understandsRequest(request)) {
            return super.getCommand(request);
        }
        return null;
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        Command superCommand = super.getResizeChildrenCommand(request);
        if (superCommand != null) {
            String label = superCommand.getLabel();
            CompositeCommand commandWrapper = new CompositeCommand(label);
            Command multiplexor = CommandsUtils.requestEditPartMultiplexor(request, label, (IGraphicalEditPart)this.getHost());
            if (multiplexor != null) {
                return multiplexor;
            }
            String labelHandleChildren = "XYLayout : Handle children";
            Object _movingEditPart = request.getEditParts().get(0);
            if (_movingEditPart instanceof IGraphicalEditPart) {
                IGraphicalEditPart movingEditPart = (IGraphicalEditPart)_movingEditPart;
                IGraphicalEditPart movingCompartmentEditPart = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(((IGraphicalEditPart)this.getHost()).getViewer().getEditPartRegistry(), (EditPart)movingEditPart);
                if (movingCompartmentEditPart == null) {
                    movingCompartmentEditPart = movingEditPart;
                }
                TransactionalEditingDomain editingDomain = ((GraphicalEditPart)this.getHost()).getEditingDomain();
                boolean isNodeConcernedByGroupFramework = GroupContainmentRegistry.isNodeConcerned(movingCompartmentEditPart);
                boolean isGroupConcernedByGroupFramework = GroupContainmentRegistry.isContainerConcerned(movingCompartmentEditPart);
                if (isNodeConcernedByGroupFramework || isGroupConcernedByGroupFramework) {
                    CompositeCommand choiceCommand;
                    Command handleChildren;
                    DiagramEditPart diagramPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)movingEditPart);
                    this.graphicalParents = new ArrayList();
                    this.modelParents = new ArrayList();
                    Utils.createComputedListsOfParents(this.graphicalParents, this.modelParents, movingEditPart, request, true);
                    this.oldGraphicalParents = new ArrayList();
                    this.oldModelParents = new ArrayList();
                    Utils.createComputedListsOfParents(this.oldGraphicalParents, this.oldModelParents, movingEditPart, request, false);
                    IGraphicalEditPart graphicalParent = CommandsUtils.setRequestParentsParameters((Request)request, this.graphicalParents, this.modelParents, (EditPart)this.getHost());
                    this.setOriginalAbsolutePositionPosition(request, movingEditPart);
                    Command relocateCommand = CommandsUtils.sendRequestSuitableHost(request, (IGraphicalEditPart)this.getHost(), this.modelParents, movingEditPart);
                    if (relocateCommand != null) {
                        return relocateCommand;
                    }
                    commandWrapper.compose((IUndoableOperation)new CommandProxy(superCommand));
                    this.updateModel(commandWrapper, movingEditPart, editingDomain);
                    this.updateMovingElementReferences(label, commandWrapper, movingEditPart, editingDomain);
                    CommandsUtils.getChangeGraphicalParentCommand(label, commandWrapper, movingEditPart, editingDomain, graphicalParent, (IGraphicalEditPart)this.getHost(), request);
                    if (isGroupConcernedByGroupFramework && (handleChildren = this.getHandleChildren(request, labelHandleChildren, movingEditPart, diagramPart, movingCompartmentEditPart, editingDomain)) != null) {
                        commandWrapper.compose((IUndoableOperation)new CommandProxy(handleChildren));
                    }
                    if ((choiceCommand = CommandsUtils.getChooseParentNotification(editingDomain, request, this.graphicalParents, this.modelParents, (IGraphicalEditPart)this.getHost())) != null) {
                        commandWrapper.compose((IUndoableOperation)choiceCommand);
                    }
                    return new ICommandProxy((ICommand)commandWrapper);
                }
                return superCommand;
            }
        }
        return superCommand;
    }

    private void updateMovingElementReferences(String label, CompositeCommand commandWrapper, IGraphicalEditPart movingEditPart, TransactionalEditingDomain editingDomain) {
        SetUpReferencesCommand setUpReferences = new SetUpReferencesCommand(editingDomain, label + ": set up references", (IAdaptable)movingEditPart, this.graphicalParents);
        if (setUpReferences != null) {
            commandWrapper.compose((IUndoableOperation)setUpReferences);
        }
        for (IGraphicalEditPart oldParent : this.oldGraphicalParents) {
            if (this.graphicalParents.contains(oldParent)) continue;
            IGraphicalEditPart oldParentCompartmentEditPart = (IGraphicalEditPart)Utils.getCompartementEditPartFromMainEditPart(oldParent.getViewer().getEditPartRegistry(), (EditPart)oldParent);
            AbstractContainerNodeDescriptor descriptor = GroupContainmentRegistry.getContainerDescriptor(oldParentCompartmentEditPart);
            UpdateReferencesCommand withDrawReference = new UpdateReferencesCommand(editingDomain, label + ": withdraw old references", Collections.singletonList(movingEditPart), descriptor, (IAdaptable)oldParent, false);
            if (withDrawReference == null) continue;
            commandWrapper.compose((IUndoableOperation)withDrawReference);
        }
    }

    private void updateModel(CompositeCommand commandWrapper, IGraphicalEditPart movingEditPart, TransactionalEditingDomain editingDomain) {
        EditPart compartmentEditPartHost;
        org.eclipse.gef.GraphicalEditPart host = this.getHost();
        if (!movingEditPart.getParent().equals(host) && host != null && (compartmentEditPartHost = Utils.getCompartementEditPartFromMainEditPart(movingEditPart.getViewer().getEditPartRegistry(), (EditPart)host)) instanceof IGraphicalEditPart) {
            ChangeModelParentCommand changeModelParent;
            AbstractContainerNodeDescriptor group = GroupContainmentRegistry.getContainerDescriptor((IGraphicalEditPart)compartmentEditPartHost);
            EReference ref = null;
            Map<EObject, EReference> child = null;
            EObject childEObject = movingEditPart.resolveSemanticElement();
            if (group != null) {
                EObject movingEObject = childEObject;
                if (movingEObject != null && group.canIBeModelParentOf(movingEObject.eClass())) {
                    ref = group.getContainmentReferenceFor(movingEObject.eClass());
                    child = Collections.singletonMap(movingEObject, ref);
                }
            } else {
                DefaultModelParent defaultModelContainer = Utils.getDefaultModelParent(childEObject.eClass(), (IGraphicalEditPart)this.getHost());
                ref = defaultModelContainer.geteReference();
                child = Collections.singletonMap(childEObject, defaultModelContainer.geteReference());
            }
            if (ref != null && child != null && (changeModelParent = new ChangeModelParentCommand(editingDomain, (IAdaptable)compartmentEditPartHost, child, movingEditPart)) != null) {
                commandWrapper.compose((IUndoableOperation)changeModelParent);
            }
        }
    }

    private void setOriginalAbsolutePositionPosition(ChangeBoundsRequest request, IGraphicalEditPart movingEditPart) {
        if (movingEditPart instanceof IGraphicalEditPart) {
            Rectangle bounds = ((Rectangle)this.getConstraintFor(request, (org.eclipse.gef.GraphicalEditPart)movingEditPart)).getCopy();
            this.translateFromLayoutRelativeToAbsolute((Translatable)bounds);
            request.getExtendedData().put("CONSTRAINT_AFTER_MOVING", bounds);
        }
    }

    private Command getHandleChildren(ChangeBoundsRequest request, String label, IGraphicalEditPart movingEditPart, DiagramEditPart diagramPart, IGraphicalEditPart movingCompartmentEditPart, TransactionalEditingDomain editingDomain) {
        CompositeCommand result = new CompositeCommand(label);
        if (movingCompartmentEditPart != null && GroupContainmentRegistry.isContainerConcerned(movingCompartmentEditPart)) {
            CompositeCommand handleChildren = null;
            Set<AbstractContainerNodeDescriptor> descriptors = GroupContainmentRegistry.getDescriptorsWithContainerEClass(movingEditPart.resolveSemanticElement().eClass());
            handleChildren = CommandsUtils.getHandleChildrenCommand(descriptors, (Request)request, diagramPart, editingDomain, (IAdaptable)movingEditPart, this.modelParents, (IGraphicalEditPart)this.getHost());
            if (handleChildren != null) {
                result.compose((IUndoableOperation)handleChildren);
            }
            if (request.getExtendedData().containsKey("ALL_AUTOMATIC_GRAPHICAL_CHILDREN")) {
                List automaticChildren = (List)request.getExtendedData().get("ALL_AUTOMATIC_GRAPHICAL_CHILDREN");
                for (IGraphicalEditPart child : automaticChildren) {
                    ChangeGraphicalParentCommand cmd;
                    if (!(child instanceof IGraphicalEditPart) || (cmd = new ChangeGraphicalParentCommand(editingDomain, label, (EditPart)movingEditPart, (EditPart)child, (IGraphicalEditPart)this.getHost(), (Request)request)) == null) continue;
                    cmd.setMode(ChangeGraphicalParentCommand.Mode.MOVE_PARENT);
                    result.compose((IUndoableOperation)cmd);
                }
            }
            result.reduce();
            if (!result.isEmpty()) {
                return new ICommandProxy((ICommand)result);
            }
            return null;
        }
        return null;
    }

    public boolean understandsRequest(Request req) {
        return XYLayoutEditGroupPolicy.canHandleCreateRequestOnlyIfNewParent(req, (IGraphicalEditPart)this.getHost());
    }

    public static boolean canHandleCreateRequestOnlyIfNewParent(Request req, IGraphicalEditPart getHost) {
        if (req.getExtendedData().containsKey("New_parent_host")) {
            IGraphicalEditPart newParent = (IGraphicalEditPart)req.getExtendedData().get("New_parent_host");
            return getHost.equals(newParent);
        }
        return true;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request.getExtendedData().containsKey("ALL_AUTOMATIC_GRAPHICAL_CHILDREN")) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            Command superCreateCommand = super.getCreateCommand(request);
            CompositeCommand compositeCreateCmd = new CompositeCommand(superCreateCommand.getLabel());
            compositeCreateCmd.compose((IUndoableOperation)new CommandProxy(superCreateCommand));
            List automaticChildren = (List)request.getExtendedData().get("ALL_AUTOMATIC_GRAPHICAL_CHILDREN");
            for (IGraphicalEditPart child : automaticChildren) {
                String label;
                ChangeGraphicalParentCommand cmd;
                if (!(child instanceof IGraphicalEditPart) || (cmd = new ChangeGraphicalParentCommand(editingDomain, label = String.valueOf(superCreateCommand) + ": Change child graphical parent", request, (EditPart)child, (IGraphicalEditPart)this.getHost())) == null) continue;
                cmd.setMode(ChangeGraphicalParentCommand.Mode.CREATION_CHILD);
                compositeCreateCmd.compose((IUndoableOperation)cmd);
            }
            return new ICommandProxy((ICommand)compositeCreateCmd);
        }
        return super.getCreateCommand(request);
    }
}

