/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.editor.preview;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;
import org.eclipse.papyrus.views.properties.toolsmiths.editor.UIEditor;
import org.eclipse.papyrus.views.properties.toolsmiths.messages.Messages;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class Preview
extends ViewPart
implements ISelectionChangedListener,
IPartListener {
    private Composite parent;
    private ScrolledComposite scrolledParent;
    private CTabFolder contents;
    private DisplayEngine displayEngine;
    private String selectedTab;
    private boolean enabled = true;
    private View currentView;
    private Label previewTitle;
    private Label previewDisabled;
    private Set<UIEditor> currentEditors = new HashSet<UIEditor>();
    private IWorkbenchPage activePage;

    public Preview() {
    }

    public Preview(UIEditor editor) {
        this.currentEditors.add(editor);
    }

    public void createPartControl(Composite container) {
        this.scrolledParent = new ScrolledComposite(container, 2816);
        this.scrolledParent.getVerticalBar().setIncrement(10);
        this.scrolledParent.setBackground(new Color((Device)this.scrolledParent.getDisplay(), 255, 255, 255));
        this.scrolledParent.setBackgroundMode(1);
        this.scrolledParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parent = new Composite((Composite)this.scrolledParent, 0);
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.scrolledParent.setContent((Control)this.parent);
        Composite controls = new Composite(this.parent, 0);
        controls.setLayout((Layout)new GridLayout(5, false));
        controls.setLayoutData((Object)new GridData(4, 4, true, false));
        this.previewTitle = new Label(controls, 0);
        GridData data = new GridData(0x1000000, 1, false, false);
        this.previewTitle.setLayoutData((Object)data);
        this.previewDisabled = new Label(this.parent, 0);
        this.previewDisabled.setLayoutData((Object)new GridData(4, 4, true, false));
        this.contents = new CTabFolder(this.parent, 512);
        if (this.currentEditors.isEmpty()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                this.activePage = window.getActivePage();
                if (this.activePage != null) {
                    IEditorPart editorPart = this.activePage.getActiveEditor();
                    if (editorPart instanceof UIEditor) {
                        this.setEditor((UIEditor)editorPart);
                    }
                    this.activePage.addPartListener((IPartListener)this);
                } else {
                    Activator.log.warn("There is no active page");
                }
            } else {
                Activator.log.warn("There is no current window");
            }
        }
        this.displayView();
    }

    public void setEditor(UIEditor editor) {
        editor.addPreview(this);
        this.currentEditors.add(editor);
    }

    private void refreshDisplay() {
        Point size = this.parent.computeSize(-1, -1);
        if (this.scrolledParent.getSize().x > 0) {
            size.x = this.scrolledParent.getSize().x - 30;
        }
        this.parent.setSize(size);
    }

    /*
     * Exception decompiling
     */
    private URL saveTmp(Section section) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setView(View view) {
        this.currentView = view;
        if (view != null) {
            if (view.getName() == null) {
                this.previewTitle.setText(Messages.Preview_Unnamed);
            } else {
                this.previewTitle.setText(view.getName());
            }
        } else {
            this.previewTitle.setText("");
        }
        this.previewTitle.getParent().layout();
        this.displayView();
    }

    private void setPreviewError(String message) {
        if (message != null) {
            this.previewDisabled.setText(message);
            this.previewDisabled.setVisible(true);
        } else {
            this.previewDisabled.setVisible(false);
        }
        this.refreshDisplay();
    }

    public void displayView() {
        this.contents.dispose();
        if (!this.enabled) {
            this.setPreviewError(Messages.Preview_previewIsDisabled);
            return;
        }
        if (this.currentView == null) {
            this.setPreviewError(Messages.Preview_noSelectedView);
            return;
        }
        this.setPreviewError(null);
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
        }
        this.displayEngine = new DefaultDisplayEngine();
        HashMap<Tab, Composite> tabs = new HashMap<Tab, Composite>();
        this.contents = new CTabFolder(this.parent, 0);
        this.contents.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean activeTab = false;
        for (Tab tab : this.getTabs(this.currentView)) {
            CTabItem tabItem = new CTabItem(this.contents, 0);
            tabItem.setText(tab.getLabel());
            if (tab.getLabel().equals(this.selectedTab) || !activeTab) {
                this.contents.setSelection(tabItem);
                activeTab = true;
            }
            Composite tabControl = new Composite((Composite)this.contents, 0);
            tabControl.setLayout((Layout)new PropertiesLayout());
            tabItem.setControl((Control)tabControl);
            tabs.put(tab, tabControl);
            tabControl.setEnabled(false);
            this.contents.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Preview.this.selectedTab = Preview.this.contents.getSelection().getText();
                }
            });
        }
        for (Section section : this.currentView.getSections()) {
            Composite tabControl = (Composite)tabs.get(section.getTab());
            if (tabControl == null) {
                Activator.log.warn("The section doesn't have a tab");
                continue;
            }
            Composite pView = new Composite(tabControl, 0);
            pView.setLayout((Layout)new GridLayout(1, false));
            URL sectionURL = this.saveTmp(section);
            if (sectionURL == null) continue;
            this.displayEngine.createSection(pView, section, URI.createURI((String)sectionURL.toExternalForm(), (boolean)true), null);
        }
        this.refreshDisplay();
    }

    private Collection<Tab> getTabs(View view) {
        LinkedList<Tab> tabs = new LinkedList<Tab>();
        for (Section section : view.getSections()) {
            Tab tab = section.getTab();
            if (tab == null || tabs.contains(tab)) continue;
            tabs.add(tab);
        }
        Collections.sort(tabs, new Comparator<Tab>(){

            @Override
            public int compare(Tab tab1, Tab tab2) {
                Tab afterTab1 = tab1.getAfterTab();
                Tab afterTab2 = tab2.getAfterTab();
                if (Preview.this.isAfter(tab1, afterTab2, new HashSet<Tab>())) {
                    return -1;
                }
                if (Preview.this.isAfter(tab2, afterTab1, new HashSet<Tab>())) {
                    return 1;
                }
                return 0;
            }
        });
        return tabs;
    }

    private boolean isAfter(Tab tab1, Tab tab2, Set<Tab> checkedTabs) {
        if (checkedTabs.contains(tab2)) {
            Activator.log.warn("Loop in the afterTabs");
            return false;
        }
        checkedTabs.add(tab2);
        if (tab2 == null) {
            return false;
        }
        if (tab1.equals(tab2)) {
            return true;
        }
        return this.isAfter(tab1, tab2.getAfterTab(), checkedTabs);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            TreeElement child = null;
            TreeElement treeElement = (TreeElement)selection.getFirstElement();
            do {
                EObject semantic;
                if (!((semantic = EMFHelper.getEObject((Object)treeElement)) instanceof View)) continue;
                this.setView((View)semantic);
                return;
            } while ((child = treeElement) != (treeElement = treeElement.getParent()) && treeElement != null);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof UIEditor) {
            this.setEditor((UIEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void dispose() {
        for (UIEditor editor : this.currentEditors) {
            editor.removePreview(this);
        }
        if (this.activePage != null) {
            this.activePage.removePartListener((IPartListener)this);
        }
        super.dispose();
    }
}

