/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusWorkbenchMarkerResolution;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;

public abstract class AbstractMissingAttributeMarkerResolution
extends AbstractPapyrusWorkbenchMarkerResolution {
    private String attribute;

    public AbstractMissingAttributeMarkerResolution(int problemID, String attribute) {
        super(problemID);
        this.attribute = attribute;
    }

    public void run(final IMarker marker) {
        if (!(marker.getResource() instanceof IFile)) {
            return;
        }
        ModelModification modification = new ModelModification((IFile)marker.getResource()){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IPluginModelBase) {
                    AbstractMissingAttributeMarkerResolution.this.addMissingAttribute((IPluginModelBase)model, marker);
                }
            }
        };
        PDEModelUtility.modifyModel((ModelModification)modification, null);
    }

    protected abstract String getAttributeValue(IMarker var1) throws CoreException;

    protected void addMissingAttribute(IPluginModelBase model, IMarker marker) throws CoreException {
        String locationPath = (String)marker.getAttribute("xmlTree.locationPath");
        IDocumentElementNode node = this.getNodeWithMarker(model, locationPath);
        String value = this.getAttributeValue(marker);
        if (value != null) {
            node.setXMLAttribute(this.attribute, value);
        }
    }

    private IDocumentElementNode getNodeWithMarker(IPluginModelBase model, String locationPath) {
        IDocumentElementNode node = null;
        StringTokenizer strtok = new StringTokenizer(locationPath, Character.toString('>'));
        while (strtok.hasMoreTokens()) {
            int attr;
            String token = strtok.nextToken();
            if (node != null) {
                IDocumentElementNode[] children = node.getChildNodes();
                int childIndex = Integer.parseInt(token.substring(1, token.indexOf(41)));
                if (childIndex >= 0 || childIndex < children.length) {
                    node = children[childIndex];
                }
            } else {
                node = (IDocumentElementNode)model.getPluginBase();
            }
            if ((attr = token.indexOf(64)) == -1) continue;
            return node;
        }
        return node;
    }
}

